/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.pinot.shaded.org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class HeartbeatResponse
extends AbstractResponse {
    private final HeartbeatResponseData data;

    public HeartbeatResponse(HeartbeatResponseData data) {
        super(ApiKeys.HEARTBEAT);
        this.data = data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    public HeartbeatResponseData data() {
        return this.data;
    }

    public static HeartbeatResponse parse(ByteBuffer buffer, short version) {
        return new HeartbeatResponse(new HeartbeatResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

