/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigResource;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiError;

public class AlterConfigsResponse
extends AbstractResponse {
    private final AlterConfigsResponseData data;

    public AlterConfigsResponse(AlterConfigsResponseData data) {
        super(ApiKeys.ALTER_CONFIGS);
        this.data = data;
    }

    public Map<ConfigResource, ApiError> errors() {
        return this.data.responses().stream().collect(Collectors.toMap(response -> new ConfigResource(ConfigResource.Type.forId(response.resourceType()), response.resourceName()), response -> new ApiError(Errors.forCode(response.errorCode()), response.errorMessage())));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public AlterConfigsResponseData data() {
        return this.data;
    }

    public static AlterConfigsResponse parse(ByteBuffer buffer, short version) {
        return new AlterConfigsResponse(new AlterConfigsResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

