/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class AddPartitionsToTxnResponse
extends AbstractResponse {
    private final AddPartitionsToTxnResponseData data;
    private Map<TopicPartition, Errors> cachedErrorsMap = null;

    public AddPartitionsToTxnResponse(AddPartitionsToTxnResponseData data) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN);
        this.data = data;
    }

    public AddPartitionsToTxnResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN);
        HashMap<String, AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection> resultMap = new HashMap<String, AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection>();
        for (Map.Entry<TopicPartition, Errors> entry : errors.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult partitionResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition());
            AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection partitionResultCollection = resultMap.getOrDefault(topicName, new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection());
            partitionResultCollection.add(partitionResult);
            resultMap.put(topicName, partitionResultCollection);
        }
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollection = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection();
        for (Map.Entry entry : resultMap.entrySet()) {
            topicCollection.add(new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult().setName((String)entry.getKey()).setResults((AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection)entry.getValue()));
        }
        this.data = new AddPartitionsToTxnResponseData().setThrottleTimeMs(throttleTimeMs).setResults(topicCollection);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Map<TopicPartition, Errors> errors() {
        if (this.cachedErrorsMap != null) {
            return this.cachedErrorsMap;
        }
        this.cachedErrorsMap = new HashMap<TopicPartition, Errors>();
        for (AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult topicResult : this.data.results()) {
            for (AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult partitionResult : topicResult.results()) {
                this.cachedErrorsMap.put(new TopicPartition(topicResult.name(), partitionResult.partitionIndex()), Errors.forCode(partitionResult.errorCode()));
            }
        }
        return this.cachedErrorsMap;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors().values());
    }

    @Override
    public AddPartitionsToTxnResponseData data() {
        return this.data;
    }

    public static AddPartitionsToTxnResponse parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

