/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common;

import java.io.Serializable;
import java.util.Objects;

public final class TopicPartition
implements Serializable {
    private static final long serialVersionUID = -613627415771699627L;
    private int hash = 0;
    private final int partition;
    private final String topic;

    public TopicPartition(String topic, int partition) {
        this.partition = partition;
        this.topic = topic;
    }

    public int partition() {
        return this.partition;
    }

    public String topic() {
        return this.topic;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.partition;
        this.hash = result = 31 * result + Objects.hashCode(this.topic);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicPartition other = (TopicPartition)obj;
        return this.partition == other.partition && Objects.equals(this.topic, other.topic);
    }

    public String toString() {
        return this.topic + "-" + this.partition;
    }
}

