/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.plugin.inputformat.avro.AvroSchemaUtil;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;

public class AvroUtils {
    private AvroUtils() {
    }

    public static org.apache.pinot.spi.data.Schema getPinotSchemaFromAvroSchema(Schema avroSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        org.apache.pinot.spi.data.Schema pinotSchema = new org.apache.pinot.spi.data.Schema();
        for (Schema.Field field : avroSchema.getFields()) {
            String fieldName = field.name();
            FieldSpec.DataType dataType = AvroUtils.extractFieldDataType(field);
            boolean isSingleValueField = AvroUtils.isSingleValueField(field);
            AvroUtils.addFieldToPinotSchema(pinotSchema, dataType, fieldName, isSingleValueField, fieldTypeMap, timeUnit);
        }
        return pinotSchema;
    }

    public static org.apache.pinot.spi.data.Schema getPinotSchemaFromAvroSchemaWithComplexTypeHandling(Schema avroSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) {
        org.apache.pinot.spi.data.Schema pinotSchema = new org.apache.pinot.spi.data.Schema();
        for (Schema.Field field : avroSchema.getFields()) {
            AvroUtils.extractSchemaWithComplexTypeHandling(field.schema(), fieldsToUnnest, delimiter, field.name(), pinotSchema, fieldTypeMap, timeUnit, collectionNotUnnestedToJson);
        }
        return pinotSchema;
    }

    public static org.apache.pinot.spi.data.Schema getPinotSchemaFromAvroDataFile(File avroDataFile, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) throws IOException {
        try (DataFileStream<GenericRecord> reader = AvroUtils.getAvroReader(avroDataFile);){
            Schema avroSchema = reader.getSchema();
            org.apache.pinot.spi.data.Schema schema = AvroUtils.getPinotSchemaFromAvroSchema(avroSchema, fieldTypeMap, timeUnit);
            return schema;
        }
    }

    public static org.apache.pinot.spi.data.Schema getPinotSchemaFromAvroDataFile(File avroDataFile) throws IOException {
        return AvroUtils.getPinotSchemaFromAvroDataFile(avroDataFile, null, null);
    }

    public static org.apache.pinot.spi.data.Schema getPinotSchemaFromAvroSchemaFile(File avroSchemaFile, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, boolean complexType, List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) throws IOException {
        Schema avroSchema = new Schema.Parser().parse(avroSchemaFile);
        if (!complexType) {
            return AvroUtils.getPinotSchemaFromAvroSchema(avroSchema, fieldTypeMap, timeUnit);
        }
        return AvroUtils.getPinotSchemaFromAvroSchemaWithComplexTypeHandling(avroSchema, fieldTypeMap, timeUnit, fieldsToUnnest, delimiter, collectionNotUnnestedToJson);
    }

    public static Schema getAvroSchemaFromPinotSchema(org.apache.pinot.spi.data.Schema pinotSchema) {
        SchemaBuilder.FieldAssembler<Schema> fieldAssembler = SchemaBuilder.record("record").fields();
        block15: for (FieldSpec fieldSpec : pinotSchema.getAllFieldSpecs()) {
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            if (fieldSpec.isSingleValueField()) {
                switch (storedType) {
                    case INT: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().intType().noDefault();
                        continue block15;
                    }
                    case LONG: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().longType().noDefault();
                        continue block15;
                    }
                    case FLOAT: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().floatType().noDefault();
                        continue block15;
                    }
                    case DOUBLE: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().doubleType().noDefault();
                        continue block15;
                    }
                    case STRING: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().stringType().noDefault();
                        continue block15;
                    }
                    case BYTES: {
                        fieldAssembler = fieldAssembler.name(fieldSpec.getName()).type().bytesType().noDefault();
                        continue block15;
                    }
                }
                throw new RuntimeException("Unsupported data type: " + storedType);
            }
            switch (storedType) {
                case INT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().intType()).noDefault();
                    continue block15;
                }
                case LONG: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().longType()).noDefault();
                    continue block15;
                }
                case FLOAT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().floatType()).noDefault();
                    continue block15;
                }
                case DOUBLE: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().doubleType()).noDefault();
                    continue block15;
                }
                case STRING: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(fieldSpec.getName()).type().array().items().stringType()).noDefault();
                    continue block15;
                }
            }
            throw new RuntimeException("Unsupported data type: " + storedType);
        }
        return fieldAssembler.endRecord();
    }

    public static DataFileStream<GenericRecord> getAvroReader(File avroFile) throws IOException {
        if (RecordReaderUtils.isGZippedFile((File)avroFile)) {
            return new DataFileStream<GenericRecord>(new GZIPInputStream(new FileInputStream(avroFile)), new GenericDatumReader());
        }
        return new DataFileStream<GenericRecord>(new FileInputStream(avroFile), new GenericDatumReader());
    }

    public static boolean isSingleValueField(Schema.Field field) {
        try {
            Schema fieldSchema = AvroUtils.extractSupportedSchema(field.schema());
            return fieldSchema.getType() != Schema.Type.ARRAY;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while extracting non-null schema from field: " + field.name(), e);
        }
    }

    public static FieldSpec.DataType extractFieldDataType(Schema.Field field) {
        try {
            Schema fieldSchema = AvroUtils.extractSupportedSchema(field.schema());
            Schema.Type fieldType = fieldSchema.getType();
            if (fieldType == Schema.Type.ARRAY) {
                return AvroSchemaUtil.valueOf(AvroUtils.extractSupportedSchema(fieldSchema.getElementType()).getType());
            }
            return AvroSchemaUtil.valueOf(fieldType);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while extracting data type from field: " + field.name(), e);
        }
    }

    private static Schema extractSupportedSchema(Schema fieldSchema) {
        Schema.Type fieldType = fieldSchema.getType();
        if (fieldType == Schema.Type.UNION) {
            Schema nonNullSchema = null;
            for (Schema childFieldSchema : fieldSchema.getTypes()) {
                if (childFieldSchema.getType() == Schema.Type.NULL) continue;
                if (nonNullSchema == null) {
                    nonNullSchema = childFieldSchema;
                    continue;
                }
                throw new IllegalStateException("More than one non-null schema in UNION schema");
            }
            if (nonNullSchema != null) {
                return AvroUtils.extractSupportedSchema(nonNullSchema);
            }
            throw new IllegalStateException("Cannot find non-null schema in UNION schema");
        }
        if (fieldType == Schema.Type.RECORD) {
            List<Schema.Field> recordFields = fieldSchema.getFields();
            Preconditions.checkState((recordFields.size() == 1 ? 1 : 0) != 0, (Object)"Not one field in the RECORD schema");
            return AvroUtils.extractSupportedSchema(recordFields.get(0).schema());
        }
        return fieldSchema;
    }

    private static void extractSchemaWithComplexTypeHandling(Schema fieldSchema, List<String> fieldsToUnnest, String delimiter, String path, org.apache.pinot.spi.data.Schema pinotSchema, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) {
        Schema.Type fieldType = fieldSchema.getType();
        switch (fieldType) {
            case UNION: {
                Schema nonNullSchema = null;
                for (Schema childFieldSchema : fieldSchema.getTypes()) {
                    if (childFieldSchema.getType() == Schema.Type.NULL) continue;
                    if (nonNullSchema == null) {
                        nonNullSchema = childFieldSchema;
                        continue;
                    }
                    throw new IllegalStateException("More than one non-null schema in UNION schema");
                }
                if (nonNullSchema != null) {
                    AvroUtils.extractSchemaWithComplexTypeHandling(nonNullSchema, fieldsToUnnest, delimiter, path, pinotSchema, fieldTypeMap, timeUnit, collectionNotUnnestedToJson);
                    break;
                }
                throw new IllegalStateException("Cannot find non-null schema in UNION schema");
            }
            case RECORD: {
                for (Schema.Field innerField : fieldSchema.getFields()) {
                    AvroUtils.extractSchemaWithComplexTypeHandling(innerField.schema(), fieldsToUnnest, delimiter, String.join((CharSequence)delimiter, path, innerField.name()), pinotSchema, fieldTypeMap, timeUnit, collectionNotUnnestedToJson);
                }
                break;
            }
            case ARRAY: {
                Schema elementType = fieldSchema.getElementType();
                if (fieldsToUnnest.contains(path)) {
                    AvroUtils.extractSchemaWithComplexTypeHandling(elementType, fieldsToUnnest, delimiter, path, pinotSchema, fieldTypeMap, timeUnit, collectionNotUnnestedToJson);
                    break;
                }
                if (collectionNotUnnestedToJson == ComplexTypeConfig.CollectionNotUnnestedToJson.NON_PRIMITIVE && AvroSchemaUtil.isPrimitiveType(elementType.getType())) {
                    AvroUtils.addFieldToPinotSchema(pinotSchema, AvroSchemaUtil.valueOf(elementType.getType()), path, false, fieldTypeMap, timeUnit);
                    break;
                }
                if (!AvroUtils.shallConvertToJson(collectionNotUnnestedToJson, elementType)) break;
                AvroUtils.addFieldToPinotSchema(pinotSchema, FieldSpec.DataType.STRING, path, true, fieldTypeMap, timeUnit);
                break;
            }
            default: {
                FieldSpec.DataType dataType = AvroSchemaUtil.valueOf(fieldType);
                AvroUtils.addFieldToPinotSchema(pinotSchema, dataType, path, true, fieldTypeMap, timeUnit);
            }
        }
    }

    private static boolean shallConvertToJson(ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson, Schema elementType) {
        switch (collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !AvroSchemaUtil.isPrimitiveType(elementType.getType());
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", collectionNotUnnestedToJson));
    }

    private static void addFieldToPinotSchema(org.apache.pinot.spi.data.Schema pinotSchema, FieldSpec.DataType dataType, String name, boolean isSingleValueField, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        if (fieldTypeMap == null) {
            pinotSchema.addField((FieldSpec)new DimensionFieldSpec(name, dataType, isSingleValueField));
        } else {
            FieldSpec.FieldType fieldType = fieldTypeMap.getOrDefault(name, FieldSpec.FieldType.DIMENSION);
            Preconditions.checkNotNull((Object)fieldType, (String)"Field type not specified for field: %s", (Object)name);
            switch (fieldType) {
                case DIMENSION: {
                    pinotSchema.addField((FieldSpec)new DimensionFieldSpec(name, dataType, isSingleValueField));
                    break;
                }
                case METRIC: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Metric field: %s cannot be multi-valued", (Object)name);
                    pinotSchema.addField((FieldSpec)new MetricFieldSpec(name, dataType));
                    break;
                }
                case DATE_TIME: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Time field: %s cannot be multi-valued", (Object)name);
                    Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"Time unit cannot be null");
                    String format = "1:" + timeUnit.name() + ":EPOCH";
                    String granularity = "1:" + timeUnit.name();
                    pinotSchema.addField((FieldSpec)new DateTimeFieldSpec(name, dataType, format, granularity));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported field type: " + fieldType + " for field: " + name);
                }
            }
        }
    }
}

