/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractor;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordReaderConfig;
import org.apache.pinot.plugin.inputformat.avro.AvroUtils;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;

public class AvroRecordReader
implements RecordReader {
    private File _dataFile;
    private AvroRecordExtractor _recordExtractor;
    private DataFileStream<GenericRecord> _avroReader;
    private GenericRecord _reusableAvroRecord = null;

    public void init(File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        AvroRecordReaderConfig config = recordReaderConfig == null ? new AvroRecordReaderConfig() : (AvroRecordReaderConfig)recordReaderConfig;
        this._dataFile = dataFile;
        this._avroReader = AvroUtils.getAvroReader(dataFile);
        AvroRecordExtractorConfig recordExtractorConfig = new AvroRecordExtractorConfig();
        recordExtractorConfig.setEnableLogicalTypes(config.isEnableLogicalTypes());
        this._recordExtractor = new AvroRecordExtractor();
        this._recordExtractor.init(fieldsToRead, recordExtractorConfig);
    }

    public boolean hasNext() {
        return this._avroReader.hasNext();
    }

    public GenericRow next() throws IOException {
        return this.next(new GenericRow());
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        this._reusableAvroRecord = this._avroReader.next(this._reusableAvroRecord);
        this._recordExtractor.extract(this._reusableAvroRecord, reuse);
        return reuse;
    }

    public void rewind() throws IOException {
        this._avroReader.close();
        this._avroReader = AvroUtils.getAvroReader(this._dataFile);
    }

    public void close() throws IOException {
        this._avroReader.close();
    }
}

