/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pinot.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pinot.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import org.apache.pinot.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.pinot.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import reactor.netty.Metrics;
import reactor.netty.internal.util.MapUtils;

final class ByteBufAllocatorMetrics {
    static final String CHUNK_SIZE_DESCRIPTION = "The chunk size for an arena.";
    static final String DIRECT_ARENAS_DESCRIPTION = "The number of direct arenas.";
    static final String HEAP_ARENAS_DESCRIPTION = "The number of heap arenas.";
    static final String NORMAL_CACHE_SIZE_DESCRIPTION = "The size of the normal cache.";
    static final String SMALL_CACHE_SIZE_DESCRIPTION = "The size of the small cache.";
    static final String THREAD_LOCAL_CACHES_DESCRIPTION = "The number of thread local caches.";
    static final String USED_DIRECT_MEMORY_DESCRIPTION = "The number of bytes reserved by direct buffer allocator.";
    static final String USED_HEAP_MEMORY_DESCRIPTION = "The number of bytes reserved by heap buffer allocator.";
    static final String ACTIVE_DIRECT_MEMORY_DESCRIPTION = "The actual bytes consumed by in-use buffers allocated from heap buffer pools.";
    static final String ACTIVE_HEAP_MEMORY_DESCRIPTION = "The actual bytes consumed by in-use buffers allocated from direct buffer pools.";
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = new ConcurrentHashMap<String, ByteBufAllocatorMetric>();

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics, ByteBufAllocator alloc) {
        MapUtils.computeIfAbsent(this.cache, metrics.hashCode() + "", key -> {
            Tags tags = Tags.of((String[])new String[]{"id", key, "type", allocType});
            Gauge.builder((String)"reactor.netty.bytebuf.allocator.used.heap.memory", (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).description(USED_HEAP_MEMORY_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
            Gauge.builder((String)"reactor.netty.bytebuf.allocator.used.direct.memory", (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).description(USED_DIRECT_MEMORY_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                PooledByteBufAllocator pooledAlloc = (PooledByteBufAllocator)alloc;
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.heap.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).description(HEAP_ARENAS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.direct.arenas", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).description(DIRECT_ARENAS_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.threadlocal.caches", (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).description(THREAD_LOCAL_CACHES_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.small.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).description(SMALL_CACHE_SIZE_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.normal.cache.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).description(NORMAL_CACHE_SIZE_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.chunk.size", (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).description(CHUNK_SIZE_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.active.heap.memory", (Object)pooledAlloc, PooledByteBufAllocator::pinnedHeapMemory).description(ACTIVE_HEAP_MEMORY_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
                Gauge.builder((String)"reactor.netty.bytebuf.allocator.active.direct.memory", (Object)pooledAlloc, PooledByteBufAllocator::pinnedDirectMemory).description(ACTIVE_DIRECT_MEMORY_DESCRIPTION).tags((Iterable)tags).register(Metrics.REGISTRY);
            }
            return metrics;
        });
    }
}

