/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import java.time.Duration;
import java.util.Objects;
import org.apache.pinot.shaded.io.netty.channel.Channel;
import org.apache.pinot.shaded.io.netty.channel.EventLoopGroup;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ColocatedEventLoopGroup;
import reactor.netty.resources.DefaultLoop;
import reactor.netty.resources.DefaultLoopNativeDetector;
import reactor.netty.resources.DefaultLoopResources;

@FunctionalInterface
public interface LoopResources
extends Disposable {
    public static final int DEFAULT_IO_WORKER_COUNT = Integer.parseInt(System.getProperty("reactor.netty.ioWorkerCount", "" + Math.max(Runtime.getRuntime().availableProcessors(), 4)));
    public static final int DEFAULT_IO_SELECT_COUNT = Integer.parseInt(System.getProperty("reactor.netty.ioSelectCount", "-1"));
    public static final boolean DEFAULT_NATIVE = Boolean.parseBoolean(System.getProperty("reactor.netty.native", "true"));
    public static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = Long.parseLong(System.getProperty("reactor.netty.ioShutdownQuietPeriod", "2"));
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.ioShutdownTimeout", "15"));

    public static EventLoopGroup colocate(EventLoopGroup group) {
        Objects.requireNonNull(group, "group");
        return new ColocatedEventLoopGroup(group);
    }

    public static LoopResources create(String prefix) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        return new DefaultLoopResources(prefix, DEFAULT_IO_SELECT_COUNT, DEFAULT_IO_WORKER_COUNT, true);
    }

    public static LoopResources create(String prefix, int workerCount, boolean daemon) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker threads number, was: " + workerCount);
        }
        return new DefaultLoopResources(prefix, workerCount, daemon);
    }

    public static LoopResources create(String prefix, int selectCount, int workerCount, boolean daemon) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker threads number, was: " + workerCount);
        }
        if (selectCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive selector threads number, was: " + selectCount);
        }
        return new DefaultLoopResources(prefix, selectCount, workerCount, daemon);
    }

    public static LoopResources create(String prefix, int selectCount, int workerCount, boolean daemon, boolean colocate) {
        if (Objects.requireNonNull(prefix, "prefix").isEmpty()) {
            throw new IllegalArgumentException("Cannot use empty prefix");
        }
        if (workerCount < 1) {
            throw new IllegalArgumentException("Must provide a strictly positive worker threads number, was: " + workerCount);
        }
        if (selectCount < 1 && selectCount != -1) {
            throw new IllegalArgumentException("Must provide a strictly positive selector threads number or -1, was: " + selectCount);
        }
        return new DefaultLoopResources(prefix, selectCount, workerCount, daemon, colocate);
    }

    default public boolean daemon() {
        return false;
    }

    @Override
    default public void dispose() {
        this.disposeLater().subscribe();
    }

    default public Mono<Void> disposeLater() {
        return this.disposeLater(Duration.ofSeconds(DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(DEFAULT_SHUTDOWN_TIMEOUT));
    }

    default public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout) {
        return Mono.empty();
    }

    default public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        DefaultLoop channelFactory = DefaultLoopNativeDetector.INSTANCE.supportGroup(group) ? DefaultLoopNativeDetector.INSTANCE : DefaultLoopNativeDetector.NIO;
        return channelFactory.getChannel(channelType);
    }

    default public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        DefaultLoop channelFactory = DefaultLoopNativeDetector.INSTANCE.supportGroup(group) ? DefaultLoopNativeDetector.INSTANCE : DefaultLoopNativeDetector.NIO;
        return channelFactory.getChannelClass(channelType);
    }

    default public EventLoopGroup onClient(boolean useNative) {
        return this.onServer(useNative);
    }

    public EventLoopGroup onServer(boolean var1);

    default public EventLoopGroup onServerSelect(boolean useNative) {
        return this.onServer(useNative);
    }

    public static boolean hasNativeSupport() {
        return DefaultLoopNativeDetector.INSTANCE != DefaultLoopNativeDetector.NIO;
    }
}

