/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.net.SocketAddress;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.pinot.shaded.io.netty.buffer.ByteBuf;
import org.apache.pinot.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.pinot.shaded.io.netty.channel.ChannelFuture;
import org.apache.pinot.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.shaded.io.netty.channel.ChannelPromise;
import org.apache.pinot.shaded.io.netty.handler.codec.DecoderResult;
import org.apache.pinot.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpObject;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import org.apache.pinot.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.pinot.shaded.io.netty.util.ReferenceCountUtil;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.logging.HttpMessageArgProviderFactory;
import reactor.netty.http.logging.HttpMessageLogFactory;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerFormDecoderProvider;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.annotation.Nullable;

final class Http2StreamBridgeServerHandler
extends ChannelDuplexHandler
implements ChannelFutureListener {
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    SocketAddress remoteAddress;
    Boolean secured;
    boolean pendingResponse;

    Http2StreamBridgeServerHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle) {
        this.compress = compress;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New HTTP/2 stream"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(ctx.channel().parent().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            try {
                this.pendingResponse = true;
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, request, this.compress, ConnectionInfo.from(ctx.channel().parent(), request, this.secured, this.remoteAddress, this.forwardedHeaderHandler), this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, true, this.mapHandle, this.secured, timestamp);
            }
            catch (RuntimeException e) {
                this.pendingResponse = false;
                request.setDecoderResult(DecoderResult.failure(e.getCause() != null ? e.getCause() : e));
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, this.secured, e, msg, this.httpMessageLogFactory, true, timestamp);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        } else if (!this.pendingResponse) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
            }
            ReferenceCountUtil.release(msg);
            ctx.read();
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                this.pendingResponse = false;
                f.addListener(this);
                ctx.read();
            }
        }
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Last HTTP packet was sent, terminating the channel"));
        }
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }
}

