/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import java.util.Map;
import java.util.function.Function;
import org.apache.pinot.shaded.io.netty.handler.codec.DecoderResult;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pinot.shaded.io.netty.util.internal.StringUtil;
import reactor.netty.http.logging.HttpMessageArgProvider;

public final class HttpMessageLogUtils {
    public static String logHttpMessage(HttpMessageArgProvider argProvider, Function<String, String> uriValueFunction, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        switch (argProvider.httpMessageType()) {
            case REQUEST: {
                return HttpMessageLogUtils.logRequest(argProvider, uriValueFunction, decoderResultFunction, headerValueFunction);
            }
            case FULL_REQUEST: {
                return HttpMessageLogUtils.logFullRequest(argProvider, uriValueFunction, decoderResultFunction, headerValueFunction);
            }
            case RESPONSE: {
                return HttpMessageLogUtils.logResponse(argProvider, decoderResultFunction, headerValueFunction);
            }
            case FULL_RESPONSE: {
                return HttpMessageLogUtils.logFullResponse(argProvider, decoderResultFunction, headerValueFunction);
            }
            case CONTENT: {
                return HttpMessageLogUtils.logContent(argProvider, decoderResultFunction);
            }
            case LAST_CONTENT: {
                return HttpMessageLogUtils.logLastContent(argProvider, decoderResultFunction, headerValueFunction);
            }
        }
        throw new IllegalArgumentException("Unknown HttpMessageType: " + (Object)((Object)argProvider.httpMessageType()));
    }

    static String logContent(HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logContent(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static String logFullRequest(HttpMessageArgProvider argProvider, Function<String, String> uriValueFunction, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logFullCommon(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.logInitialLine(buf, argProvider, uriValueFunction);
        HttpMessageLogUtils.logHeaders(buf, argProvider.headers(), headerValueFunction);
        HttpMessageLogUtils.logHeaders(buf, argProvider.trailingHeaders(), headerValueFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static String logFullResponse(HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logFullCommon(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.logInitialLine(buf, argProvider);
        HttpMessageLogUtils.logHeaders(buf, argProvider.headers(), headerValueFunction);
        HttpMessageLogUtils.logHeaders(buf, argProvider.trailingHeaders(), headerValueFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static String logLastContent(HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logContent(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.logHeaders(buf, argProvider.trailingHeaders(), headerValueFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static String logRequest(HttpMessageArgProvider argProvider, Function<String, String> uriValueFunction, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logCommon(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.logInitialLine(buf, argProvider, uriValueFunction);
        HttpMessageLogUtils.logHeaders(buf, argProvider.headers(), headerValueFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static String logResponse(HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction, Function<Map.Entry<String, String>, String> headerValueFunction) {
        StringBuilder buf = new StringBuilder(256);
        HttpMessageLogUtils.logCommon(buf, argProvider, decoderResultFunction);
        HttpMessageLogUtils.logInitialLine(buf, argProvider);
        HttpMessageLogUtils.logHeaders(buf, argProvider.headers(), headerValueFunction);
        HttpMessageLogUtils.removeLastNewLine(buf);
        return buf.toString();
    }

    static void logCommon(StringBuilder buf, HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction) {
        buf.append((Object)argProvider.httpMessageType());
        buf.append("(decodeResult: ");
        buf.append(decoderResultFunction.apply(argProvider.decoderResult()));
        buf.append(", version: ");
        buf.append(argProvider.protocol());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
    }

    static void logContent(StringBuilder buf, HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction) {
        buf.append((Object)argProvider.httpMessageType());
        buf.append("(decodeResult: ");
        buf.append(decoderResultFunction.apply(argProvider.decoderResult()));
        buf.append(", content: ");
        buf.append(argProvider.content());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
    }

    static void logFullCommon(StringBuilder buf, HttpMessageArgProvider argProvider, Function<DecoderResult, String> decoderResultFunction) {
        buf.append((Object)argProvider.httpMessageType());
        buf.append("(decodeResult: ");
        buf.append(decoderResultFunction.apply(argProvider.decoderResult()));
        buf.append(", version: ");
        buf.append(argProvider.protocol());
        buf.append(", content: ");
        buf.append(argProvider.content());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
    }

    static void logHeaders(StringBuilder buf, HttpHeaders headers, Function<Map.Entry<String, String>, String> headerValueFunction) {
        for (Map.Entry<String, String> e : headers) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(headerValueFunction.apply(e));
            buf.append(StringUtil.NEWLINE);
        }
    }

    static void logInitialLine(StringBuilder buf, HttpMessageArgProvider argProvider) {
        buf.append(argProvider.protocol());
        buf.append(' ');
        buf.append(argProvider.status());
        buf.append(StringUtil.NEWLINE);
    }

    static void logInitialLine(StringBuilder buf, HttpMessageArgProvider argProvider, Function<String, String> uriValueFunction) {
        buf.append(argProvider.method());
        buf.append(' ');
        buf.append(uriValueFunction.apply(argProvider.uri()));
        buf.append(' ');
        buf.append(argProvider.protocol());
        buf.append(StringUtil.NEWLINE);
    }

    static void removeLastNewLine(StringBuilder buf) {
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
    }

    private HttpMessageLogUtils() {
    }
}

