/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import org.apache.pinot.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.pinot.shaded.io.netty.handler.codec.http.LastHttpContent;
import reactor.netty.http.logging.FullHttpRequestArgProvider;
import reactor.netty.http.logging.FullHttpResponseArgProvider;
import reactor.netty.http.logging.HttpContentArgProvider;
import reactor.netty.http.logging.HttpMessageArgProvider;
import reactor.netty.http.logging.HttpRequestArgProvider;
import reactor.netty.http.logging.HttpResponseArgProvider;
import reactor.netty.http.logging.LastHttpContentArgProvider;

public final class HttpMessageArgProviderFactory {
    public static HttpMessageArgProvider create(Object httpObject) {
        if (httpObject instanceof FullHttpRequest) {
            return new FullHttpRequestArgProvider((FullHttpRequest)httpObject);
        }
        if (httpObject instanceof HttpRequest) {
            return new HttpRequestArgProvider((HttpRequest)httpObject);
        }
        if (httpObject instanceof FullHttpResponse) {
            return new FullHttpResponseArgProvider((FullHttpResponse)httpObject);
        }
        if (httpObject instanceof HttpResponse) {
            return new HttpResponseArgProvider((HttpResponse)httpObject);
        }
        if (httpObject instanceof LastHttpContent) {
            return new LastHttpContentArgProvider((LastHttpContent)httpObject);
        }
        if (httpObject instanceof HttpContent) {
            return new HttpContentArgProvider((HttpContent)httpObject);
        }
        throw new IllegalArgumentException("Unknown object: " + httpObject);
    }

    private HttpMessageArgProviderFactory() {
    }
}

