/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.pinot.shaded.io.netty.resolver.AddressResolverGroup;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.HttpResources;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.TransportConfig;
import reactor.util.annotation.Nullable;

final class HttpConnectionProvider
implements ConnectionProvider {
    final ConnectionProvider http1ConnectionProvider;
    final AtomicReference<ConnectionProvider> h2ConnectionProvider = new AtomicReference();
    static final Function<ConnectionProvider, ConnectionProvider> HTTP2_CONNECTION_PROVIDER_FACTORY = Http2ConnectionProvider::new;

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver connectionObserver, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        if (((HttpClientConfig)config)._protocols == 4) {
            return this.http1ConnectionProvider().acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        if (this.http1ConnectionProvider == null) {
            return HttpResources.get().getOrCreateHttp2ConnectionProvider(HTTP2_CONNECTION_PROVIDER_FACTORY).acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        return this.getOrCreate().acquire(config, connectionObserver, remoteAddress, resolverGroup);
    }

    @Override
    public void disposeWhen(SocketAddress address) {
        this.http1ConnectionProvider().disposeWhen(address);
    }

    @Override
    public int maxConnections() {
        return this.http1ConnectionProvider().maxConnections();
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.http1ConnectionProvider().maxConnectionsPerHost();
    }

    HttpConnectionProvider() {
        this(null);
    }

    HttpConnectionProvider(@Nullable ConnectionProvider http1ConnectionProvider) {
        this.http1ConnectionProvider = http1ConnectionProvider;
    }

    ConnectionProvider getOrCreate() {
        ConnectionProvider provider = this.h2ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = HTTP2_CONNECTION_PROVIDER_FACTORY.apply(this.http1ConnectionProvider);
            if (!this.h2ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreate();
        }
        return provider;
    }

    ConnectionProvider http1ConnectionProvider() {
        return this.http1ConnectionProvider != null ? this.http1ConnectionProvider : HttpResources.get();
    }
}

