/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.apache.pinot.shaded.io.netty.handler.codec.http2.Http2SecurityUtil;
import org.apache.pinot.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.apache.pinot.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.apache.pinot.shaded.io.netty.handler.ssl.SslProvider;
import org.apache.pinot.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

public final class Http2SslContextSpec
extends AbstractProtocolSslContextSpec<Http2SslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> sslCtxBuilder.sslProvider(SslProvider.isAlpnSupported(SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK).ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1"));

    public static Http2SslContextSpec forClient() {
        return new Http2SslContextSpec(SslContextBuilder.forClient());
    }

    public static Http2SslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile));
    }

    public static Http2SslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
    }

    public static Http2SslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream));
    }

    public static Http2SslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream, keyPassword));
    }

    public static Http2SslContextSpec forServer(KeyManager keyManager) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyManager));
    }

    public static Http2SslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(keyManagerFactory));
    }

    public static Http2SslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    public static Http2SslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static Http2SslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static Http2SslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new Http2SslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    Http2SslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public Http2SslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

