/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.Cookie;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.CookieDecoder;
import org.apache.pinot.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;

public class Cookies {
    static final int NOT_READ = 0;
    static final int READING = 1;
    static final int READ = 2;
    final HttpHeaders nettyHeaders;
    final CharSequence cookiesHeaderName;
    final boolean isClientChannel;
    final CookieDecoder decoder;
    protected Map<CharSequence, Set<Cookie>> cachedCookies;
    volatile int state;
    static final AtomicIntegerFieldUpdater<Cookies> STATE = AtomicIntegerFieldUpdater.newUpdater(Cookies.class, "state");

    public static Cookies newClientResponseHolder(HttpHeaders headers, ClientCookieDecoder decoder) {
        return new Cookies(headers, HttpHeaderNames.SET_COOKIE, true, decoder);
    }

    @Deprecated
    public static Cookies newServerRequestHolder(HttpHeaders headers, ServerCookieDecoder decoder) {
        return new Cookies(headers, HttpHeaderNames.COOKIE, false, decoder);
    }

    protected Cookies(HttpHeaders nettyHeaders, CharSequence cookiesHeaderName, boolean isClientChannel, CookieDecoder decoder) {
        this.nettyHeaders = Objects.requireNonNull(nettyHeaders, "nettyHeaders");
        this.cookiesHeaderName = cookiesHeaderName;
        this.isClientChannel = isClientChannel;
        this.decoder = Objects.requireNonNull(decoder, "decoder");
        this.cachedCookies = Collections.emptyMap();
    }

    public Map<CharSequence, Set<Cookie>> getCachedCookies() {
        if (!this.markReadingCookies()) {
            while (!this.hasReadCookies()) {
            }
            return this.cachedCookies;
        }
        List<String> allCookieHeaders = this.allCookieHeaders();
        HashMap<String, Set> cookies = new HashMap<String, Set>();
        for (String aCookieHeader : allCookieHeaders) {
            if (this.isClientChannel) {
                Cookie c = ((ClientCookieDecoder)this.decoder).decode(aCookieHeader);
                if (c == null) continue;
                Set existingCookiesOfName = cookies.computeIfAbsent(c.name(), k -> new HashSet());
                existingCookiesOfName.add(c);
                continue;
            }
            Set<Cookie> decode = ((ServerCookieDecoder)this.decoder).decode(aCookieHeader);
            for (Cookie cookie : decode) {
                Set existingCookiesOfName = cookies.computeIfAbsent(cookie.name(), k -> new HashSet());
                existingCookiesOfName.add(cookie);
            }
        }
        this.cachedCookies = Collections.unmodifiableMap(cookies);
        this.markReadCookies();
        return this.cachedCookies;
    }

    protected List<String> allCookieHeaders() {
        return this.nettyHeaders.getAll(this.cookiesHeaderName);
    }

    protected final boolean hasReadCookies() {
        return this.state == 2;
    }

    protected final boolean markReadCookies() {
        return STATE.compareAndSet(this, 1, 2);
    }

    protected final boolean markReadingCookies() {
        return STATE.compareAndSet(this, 0, 1);
    }
}

