/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.io.netty.resolver.dns;

import java.net.UnknownHostException;
import java.util.List;
import org.apache.pinot.shaded.io.netty.channel.Channel;
import org.apache.pinot.shaded.io.netty.channel.EventLoop;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsRecord;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.pinot.shaded.io.netty.resolver.dns.DnsCnameCache;
import org.apache.pinot.shaded.io.netty.resolver.dns.DnsNameResolver;
import org.apache.pinot.shaded.io.netty.resolver.dns.DnsResolveContext;
import org.apache.pinot.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.pinot.shaded.io.netty.resolver.dns.NoopDnsCnameCache;
import org.apache.pinot.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pinot.shaded.io.netty.util.concurrent.Promise;

final class DnsRecordResolveContext
extends DnsResolveContext<DnsRecord> {
    DnsRecordResolveContext(DnsNameResolver parent, Channel channel, Promise<?> originalPromise, DnsQuestion question, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        this(parent, channel, originalPromise, question.name(), question.dnsClass(), new DnsRecordType[]{question.type()}, additionals, nameServerAddrs, allowedQueries);
    }

    private DnsRecordResolveContext(DnsNameResolver parent, Channel channel, Promise<?> originalPromise, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        super(parent, channel, originalPromise, hostname, dnsClass, expectedTypes, additionals, nameServerAddrs, allowedQueries);
    }

    @Override
    DnsResolveContext<DnsRecord> newResolverContext(DnsNameResolver parent, Channel channel, Promise<?> originalPromise, String hostname, int dnsClass, DnsRecordType[] expectedTypes, DnsRecord[] additionals, DnsServerAddressStream nameServerAddrs, int allowedQueries) {
        return new DnsRecordResolveContext(parent, channel, originalPromise, hostname, dnsClass, expectedTypes, additionals, nameServerAddrs, allowedQueries);
    }

    @Override
    DnsRecord convertRecord(DnsRecord record, String hostname, DnsRecord[] additionals, EventLoop eventLoop) {
        return ReferenceCountUtil.retain(record);
    }

    @Override
    List<DnsRecord> filterResults(List<DnsRecord> unfiltered) {
        return unfiltered;
    }

    @Override
    boolean isCompleteEarly(DnsRecord resolved) {
        return false;
    }

    @Override
    boolean isDuplicateAllowed() {
        return true;
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, DnsRecord result, DnsRecord convertedResult) {
    }

    @Override
    void cache(String hostname, DnsRecord[] additionals, UnknownHostException cause) {
    }

    @Override
    DnsCnameCache cnameCache() {
        return NoopDnsCnameCache.INSTANCE;
    }
}

