/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.io.netty.handler.codec.dns;

import java.net.InetSocketAddress;
import java.util.List;
import org.apache.pinot.shaded.io.netty.buffer.ByteBuf;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandler;
import org.apache.pinot.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.pinot.shaded.io.netty.channel.socket.DatagramPacket;
import org.apache.pinot.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DatagramDnsQuery;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsMessageUtil;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsOpCode;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsQuery;
import org.apache.pinot.shaded.io.netty.handler.codec.dns.DnsRecordDecoder;
import org.apache.pinot.shaded.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class DatagramDnsQueryDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsQueryDecoder(DnsRecordDecoder recordDecoder) {
        this.recordDecoder = ObjectUtil.checkNotNull(recordDecoder, "recordDecoder");
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, final DatagramPacket packet, List<Object> out) throws Exception {
        DnsQuery query = DnsMessageUtil.decodeDnsQuery(this.recordDecoder, (ByteBuf)packet.content(), new DnsMessageUtil.DnsQueryFactory(){

            @Override
            public DnsQuery newQuery(int id, DnsOpCode dnsOpCode) {
                return new DatagramDnsQuery((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), id, dnsOpCode);
            }
        });
        out.add(query);
    }
}

