/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.filesystem;

import com.microsoft.azure.datalake.store.ADLFileInputStream;
import com.microsoft.azure.datalake.store.ADLFileOutputStream;
import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.DirectoryEntryType;
import com.microsoft.azure.datalake.store.IfExists;
import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.collect.ImmutableList;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.BasePinotFS;
import org.apache.pinot.spi.filesystem.FileMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzurePinotFS
extends BasePinotFS {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzurePinotFS.class);
    private static final int BUFFER_SIZE = 4096;
    private ADLStoreClient _adlStoreClient;
    private static final String[] EMPTY_ARR = new String[0];
    public static final String ACCOUNT_ID = "accountId";
    public static final String AUTH_ENDPOINT = "authEndpoint";
    public static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";

    public AzurePinotFS() {
    }

    @VisibleForTesting
    public AzurePinotFS(ADLStoreClient adlStoreClient) {
        this._adlStoreClient = adlStoreClient;
    }

    public void init(PinotConfiguration config) {
        String account = config.getProperty(ACCOUNT_ID);
        String authEndpoint = config.getProperty(AUTH_ENDPOINT);
        String clientId = config.getProperty(CLIENT_ID);
        String clientSecret = config.getProperty(CLIENT_SECRET);
        ClientCredsTokenProvider tokenProvider = new ClientCredsTokenProvider(authEndpoint, clientId, clientSecret);
        this._adlStoreClient = ADLStoreClient.createClient(account, (AccessTokenProvider)tokenProvider);
    }

    public boolean mkdir(URI uri) throws IOException {
        return this._adlStoreClient.createDirectory(uri.getPath());
    }

    public boolean delete(URI segmentUri, boolean forceDelete) throws IOException {
        if (this.isDirectory(segmentUri) && this.listFiles(segmentUri, false).length > 0 && !forceDelete) {
            return false;
        }
        return this._adlStoreClient.deleteRecursive(segmentUri.getPath());
    }

    public boolean doMove(URI srcUri, URI dstUri) throws IOException {
        return this._adlStoreClient.rename(srcUri.getPath(), dstUri.getPath());
    }

    public boolean copyDir(URI srcUri, URI dstUri) throws IOException {
        if (this.isDirectory(srcUri)) {
            throw new UnsupportedOperationException("Azure FS doesn't support directory recursive copy!");
        }
        if (this.exists(dstUri)) {
            this.delete(dstUri, true);
        }
        this._adlStoreClient.createEmptyFile(dstUri.getPath());
        try {
            int bytesRead;
            ADLFileInputStream inputStream = this._adlStoreClient.getReadStream(srcUri.getPath());
            ADLFileOutputStream outputStream = this._adlStoreClient.getAppendStream(dstUri.getPath());
            byte[] buffer = new byte[4096];
            while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            LOGGER.error("Exception encountered during copy, input: '{}', output: '{}'.", srcUri, dstUri, e);
            return false;
        }
        return true;
    }

    public boolean exists(URI fileUri) throws IOException {
        return this._adlStoreClient.checkExists(fileUri.getPath());
    }

    public long length(URI fileUri) throws IOException {
        DirectoryEntry ent = this._adlStoreClient.getDirectoryEntry(fileUri.getPath());
        return ent.length;
    }

    public String[] listFiles(URI fileUri, boolean recursive) throws IOException {
        DirectoryEntry rootDir = this._adlStoreClient.getDirectoryEntry(fileUri.getPath());
        if (rootDir == null) {
            return EMPTY_ARR;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        this.visitFiles(fileUri, recursive, f -> builder.add((Object)f.fullName));
        String[] listedFiles = (String[])builder.build().toArray((Object[])new String[0]);
        LOGGER.debug("Listed {} files from URI: {}, is recursive: {}", listedFiles.length, fileUri, recursive);
        return listedFiles;
    }

    public List<FileMetadata> listFilesWithMetadata(URI fileUri, boolean recursive) throws IOException {
        DirectoryEntry rootDir = this._adlStoreClient.getDirectoryEntry(fileUri.getPath());
        if (rootDir == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        this.visitFiles(fileUri, recursive, f -> {
            FileMetadata.Builder fileBuilder = new FileMetadata.Builder().setFilePath(f.fullName).setLastModifiedTime(f.lastModifiedTime.getTime()).setLength(f.length).setIsDirectory(f.type.equals((Object)DirectoryEntryType.DIRECTORY));
            listBuilder.add((Object)fileBuilder.build());
        });
        ImmutableList listedFiles = listBuilder.build();
        LOGGER.debug("Listed {} files from URI: {}, is recursive: {}", listedFiles.size(), fileUri, recursive);
        return listedFiles;
    }

    private void visitFiles(URI fileUri, boolean recursive, Consumer<DirectoryEntry> visitor) throws IOException {
        DirectoryEntry rootDir = this._adlStoreClient.getDirectoryEntry(fileUri.getPath());
        if (rootDir == null) {
            throw new IllegalArgumentException("fileUri does not exist: " + fileUri);
        }
        if (!recursive) {
            this._adlStoreClient.enumerateDirectory(rootDir.fullName).forEach(visitor);
        } else {
            this.visitFilesRecursively(rootDir, visitor);
        }
    }

    private void visitFilesRecursively(DirectoryEntry origDirEntry, Consumer<DirectoryEntry> visitor) throws IOException {
        for (DirectoryEntry directoryEntry : this._adlStoreClient.enumerateDirectory(origDirEntry.fullName)) {
            System.out.println("directoryEntry:" + directoryEntry.fullName);
            visitor.accept(directoryEntry);
            if (!directoryEntry.type.equals((Object)DirectoryEntryType.DIRECTORY)) continue;
            this.visitFilesRecursively(directoryEntry, visitor);
        }
    }

    public void copyToLocalFile(URI srcUri, File dstFile) throws Exception {
        if (dstFile.exists()) {
            if (dstFile.isDirectory()) {
                FileUtils.deleteDirectory((File)dstFile);
            } else {
                FileUtils.deleteQuietly((File)dstFile);
            }
        }
        try (ADLFileInputStream adlStream = this._adlStoreClient.getReadStream(srcUri.getPath());){
            Path dstFilePath = Paths.get(dstFile.toURI());
            Files.copy(adlStream, dstFilePath, new CopyOption[0]);
        }
    }

    public void copyFromLocalFile(File srcFile, URI dstUri) throws Exception {
        ADLFileOutputStream stream = this._adlStoreClient.createFile(dstUri.getPath(), IfExists.OVERWRITE);
        PrintStream out = new PrintStream(stream);
        byte[] inputStream = IOUtils.toByteArray((InputStream)new FileInputStream(srcFile));
        out.write(inputStream);
        out.close();
    }

    public boolean isDirectory(URI uri) {
        DirectoryEntry dirEntry;
        try {
            dirEntry = this._adlStoreClient.getDirectoryEntry(uri.getPath());
        }
        catch (IOException e) {
            LOGGER.error("Could not get directory entry for {}", (Object)uri);
            throw new RuntimeException(e);
        }
        return dirEntry.type.equals((Object)DirectoryEntryType.DIRECTORY);
    }

    public long lastModified(URI uri) {
        try {
            return this._adlStoreClient.getDirectoryEntry((String)uri.getPath()).lastModifiedTime.getTime();
        }
        catch (IOException e) {
            LOGGER.error("Could not get directory entry for {}", (Object)uri);
            throw new RuntimeException(e);
        }
    }

    public boolean touch(URI uri) throws IOException {
        if (!this.exists(uri)) {
            this._adlStoreClient.createEmptyFile(uri.getPath());
        } else {
            this._adlStoreClient.setTimes(uri.getPath(), null, new Date());
        }
        return true;
    }

    public InputStream open(URI uri) throws IOException {
        return this._adlStoreClient.getReadStream(uri.getPath());
    }
}

