/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADAuthenticator;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredsTokenProvider
extends AccessTokenProvider {
    private static final Logger log = LoggerFactory.getLogger("com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider");
    private final String authEndpoint;
    private final String clientId;
    private final String clientSecret;

    public ClientCredsTokenProvider(String authEndpoint, String clientId, String clientSecret) {
        this.authEndpoint = authEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        log.debug("AADToken: refreshing client-credential based token");
        return AzureADAuthenticator.getTokenUsingClientCreds(this.authEndpoint, this.clientId, this.clientSecret);
    }
}

