/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="null")
public final class PathsReadHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-lease-status")
    private String xMsLeaseStatus;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="x-ms-lease-state")
    private String xMsLeaseState;
    @JsonProperty(value="x-ms-content-md5")
    private String xMsContentMd5;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-properties")
    private String xMsProperties;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String xMsEncryptionKeySha256;
    @JsonProperty(value="x-ms-request-server-encrypted")
    private Boolean xMsRequestServerEncrypted;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="x-ms-resource-type")
    private String xMsResourceType;
    @JsonProperty(value="Content-MD5")
    private String contentMD5;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="x-ms-lease-duration")
    private String xMsLeaseDuration;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Content-Type")
    private String contentType;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_LEASE_STATUS = HttpHeaderName.fromString("x-ms-lease-status");
    private static final HttpHeaderName X_MS_LEASE_STATE = HttpHeaderName.fromString("x-ms-lease-state");
    private static final HttpHeaderName X_MS_CONTENT_MD5 = HttpHeaderName.fromString("x-ms-content-md5");
    private static final HttpHeaderName X_MS_PROPERTIES = HttpHeaderName.fromString("x-ms-properties");
    private static final HttpHeaderName X_MS_ENCRYPTION_KEY_SHA256 = HttpHeaderName.fromString("x-ms-encryption-key-sha256");
    private static final HttpHeaderName X_MS_REQUEST_SERVER_ENCRYPTED = HttpHeaderName.fromString("x-ms-request-server-encrypted");
    private static final HttpHeaderName X_MS_RESOURCE_TYPE = HttpHeaderName.fromString("x-ms-resource-type");
    private static final HttpHeaderName X_MS_LEASE_DURATION = HttpHeaderName.fromString("x-ms-lease-duration");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");

    public PathsReadHeaders(HttpHeaders rawHeaders) {
        String date;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsLeaseStatus = rawHeaders.getValue(X_MS_LEASE_STATUS);
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        this.xMsLeaseState = rawHeaders.getValue(X_MS_LEASE_STATE);
        this.xMsContentMd5 = rawHeaders.getValue(X_MS_CONTENT_MD5);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        this.xMsProperties = rawHeaders.getValue(X_MS_PROPERTIES);
        this.xMsEncryptionKeySha256 = rawHeaders.getValue(X_MS_ENCRYPTION_KEY_SHA256);
        String xMsRequestServerEncrypted = rawHeaders.getValue(X_MS_REQUEST_SERVER_ENCRYPTED);
        if (xMsRequestServerEncrypted != null) {
            this.xMsRequestServerEncrypted = Boolean.parseBoolean(xMsRequestServerEncrypted);
        }
        if ((date = rawHeaders.getValue(HttpHeaderName.DATE)) != null) {
            this.date = new DateTimeRfc1123(date);
        }
        this.xMsResourceType = rawHeaders.getValue(X_MS_RESOURCE_TYPE);
        this.contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5);
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        this.xMsLeaseDuration = rawHeaders.getValue(X_MS_LEASE_DURATION);
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLength != null) {
            this.contentLength = Long.parseLong(contentLength);
        }
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsReadHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public PathsReadHeaders setXMsLeaseStatus(String xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public PathsReadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public PathsReadHeaders setXMsLeaseState(String xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public String getXMsContentMd5() {
        return this.xMsContentMd5;
    }

    public PathsReadHeaders setXMsContentMd5(String xMsContentMd5) {
        this.xMsContentMd5 = xMsContentMd5;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsReadHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsProperties() {
        return this.xMsProperties;
    }

    public PathsReadHeaders setXMsProperties(String xMsProperties) {
        this.xMsProperties = xMsProperties;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public PathsReadHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public Boolean isXMsRequestServerEncrypted() {
        return this.xMsRequestServerEncrypted;
    }

    public PathsReadHeaders setXMsRequestServerEncrypted(Boolean xMsRequestServerEncrypted) {
        this.xMsRequestServerEncrypted = xMsRequestServerEncrypted;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsReadHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getXMsResourceType() {
        return this.xMsResourceType;
    }

    public PathsReadHeaders setXMsResourceType(String xMsResourceType) {
        this.xMsResourceType = xMsResourceType;
        return this;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public PathsReadHeaders setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public PathsReadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public PathsReadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsReadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public PathsReadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public PathsReadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public PathsReadHeaders setXMsLeaseDuration(String xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public PathsReadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsReadHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public PathsReadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PathsReadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

