/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.util.ChunkedDownloadUtils;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadContentAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadContentResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobLegalHoldResult;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobQueryHeaders;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSeekableByteChannelReadResult;
import com.azure.storage.blob.models.ConsistentReadControl;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobBeginCopyOptions;
import com.azure.storage.blob.options.BlobCopyFromUrlOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobGetTagsOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobSeekableByteChannelReadOptions;
import com.azure.storage.blob.options.BlobSetAccessTierOptions;
import com.azure.storage.blob.options.BlobSetTagsOptions;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.StorageSeekableByteChannelBlobReadBehavior;
import com.azure.storage.common.implementation.FluxInputStream;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.util.ByteBufferBackedOutputStream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(BlobClientBase.class);
    private final BlobAsyncClientBase client;

    protected BlobClientBase(BlobAsyncClientBase client) {
        this.client = client;
    }

    public BlobClientBase getSnapshotClient(String snapshot) {
        return new BlobClientBase(this.client.getSnapshotClient(snapshot));
    }

    public BlobClientBase getVersionClient(String versionId) {
        return new BlobClientBase(this.client.getVersionClient(versionId));
    }

    public BlobClientBase getEncryptionScopeClient(String encryptionScope) {
        return new BlobClientBase(this.client.getEncryptionScopeAsyncClient(encryptionScope));
    }

    public BlobClientBase getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new BlobClientBase(this.client.getCustomerProvidedKeyAsyncClient(customerProvidedKey));
    }

    public String getAccountUrl() {
        return this.client.getAccountUrl();
    }

    public String getBlobUrl() {
        return this.client.getBlobUrl();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public final String getContainerName() {
        return this.client.getContainerName();
    }

    public BlobContainerClient getContainerClient() {
        return this.client.getContainerClientBuilder().buildClient();
    }

    public final String getBlobName() {
        return this.client.getBlobName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.client.getCustomerProvidedKey();
    }

    String getEncryptionScope() {
        return this.client.getEncryptionScope();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public String getSnapshotId() {
        return this.client.getSnapshotId();
    }

    public String getVersionId() {
        return this.client.getVersionId();
    }

    public boolean isSnapshot() {
        return this.client.isSnapshot();
    }

    public BlobInputStream openInputStream() {
        return this.openInputStream((BlobRange)null, null);
    }

    public BlobInputStream openInputStream(BlobRange range, BlobRequestConditions requestConditions) {
        return this.openInputStream(new BlobInputStreamOptions().setRange(range).setRequestConditions(requestConditions));
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options) {
        return this.openInputStream(options, null);
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options, Context context) {
        Context contextFinal = context == null ? Context.NONE : context;
        options = options == null ? new BlobInputStreamOptions() : options;
        ConsistentReadControl consistentReadControl = options.getConsistentReadControl() == null ? ConsistentReadControl.ETAG : options.getConsistentReadControl();
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        BlobRange range = options.getRange() == null ? new BlobRange(0L) : options.getRange();
        int chunkSize = options.getBlockSize() == null ? 0x400000 : options.getBlockSize();
        com.azure.storage.common.ParallelTransferOptions parallelTransferOptions = new com.azure.storage.common.ParallelTransferOptions().setBlockSizeLong(Long.valueOf(chunkSize));
        BiFunction<BlobRange, BlobRequestConditions, Mono<BlobDownloadAsyncResponse>> downloadFunc = (chunkRange, conditions) -> this.client.downloadStreamWithResponse((BlobRange)chunkRange, null, (BlobRequestConditions)conditions, false, contextFinal);
        return (BlobInputStream)ChunkedDownloadUtils.downloadFirstChunk(range, parallelTransferOptions, requestConditions, downloadFunc, true).flatMap(tuple3 -> {
            BlobDownloadAsyncResponse downloadResponse = (BlobDownloadAsyncResponse)tuple3.getT3();
            return FluxUtil.collectBytesInByteBufferStream((Flux)downloadResponse.getValue()).map(ByteBuffer::wrap).zipWith(Mono.just(downloadResponse));
        }).flatMap(tuple2 -> {
            ByteBuffer initialBuffer = (ByteBuffer)tuple2.getT1();
            BlobDownloadAsyncResponse downloadResponse = (BlobDownloadAsyncResponse)tuple2.getT2();
            BlobProperties properties = ModelHelper.buildBlobPropertiesResponse(downloadResponse).getValue();
            String eTag = properties.getETag();
            String versionId = properties.getVersionId();
            BlobAsyncClientBase client = this.client;
            switch (consistentReadControl) {
                case NONE: {
                    break;
                }
                case ETAG: {
                    if (requestConditions.getIfMatch() != null) break;
                    requestConditions.setIfMatch(eTag);
                    break;
                }
                case VERSION_ID: {
                    if (versionId == null) {
                        return FluxUtil.monoError(LOGGER, (RuntimeException)new UnsupportedOperationException("Versioning is not supported on this account."));
                    }
                    if (this.client.getVersionId() != null) break;
                    client = this.client.getVersionClient(versionId);
                    break;
                }
                default: {
                    return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalArgumentException("Concurrency control type not supported."));
                }
            }
            return Mono.just(new BlobInputStream(client, range.getOffset(), range.getCount(), chunkSize, initialBuffer, requestConditions, properties, contextFinal));
        }).block();
    }

    public BlobSeekableByteChannelReadResult openSeekableByteChannelRead(BlobSeekableByteChannelReadOptions options, Context context) {
        BlobProperties properties;
        context = context == null ? Context.NONE : context;
        options = options == null ? new BlobSeekableByteChannelReadOptions() : options;
        ConsistentReadControl consistentReadControl = options.getConsistentReadControl() == null ? ConsistentReadControl.ETAG : options.getConsistentReadControl();
        int chunkSize = options.getReadSizeInBytes() == null ? 0x400000 : options.getReadSizeInBytes();
        long initialPosition = options.getInitialPosition() == null ? 0L : options.getInitialPosition();
        ByteBuffer initialRange = ByteBuffer.allocate(chunkSize);
        try (ByteBufferBackedOutputStream dstStream = new ByteBufferBackedOutputStream(initialRange);){
            BlobDownloadResponse response = this.downloadStreamWithResponse(dstStream, new BlobRange(initialPosition, Long.valueOf(initialRange.remaining())), null, options.getRequestConditions(), false, null, context);
            properties = ModelHelper.buildBlobPropertiesResponse(response).getValue();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
        }
        initialRange.limit(initialRange.position());
        initialRange.rewind();
        BlobClientBase behaviorClient = this;
        BlobRequestConditions requestConditions = options.getRequestConditions();
        switch (consistentReadControl) {
            case NONE: {
                break;
            }
            case ETAG: {
                BlobRequestConditions blobRequestConditions = requestConditions = requestConditions != null ? requestConditions : new BlobRequestConditions();
                if (requestConditions.getIfMatch() != null) break;
                requestConditions.setIfMatch(properties.getETag());
                break;
            }
            case VERSION_ID: {
                if (properties.getVersionId() == null) {
                    throw LOGGER.logExceptionAsError(new UnsupportedOperationException("Version ID locking unsupported. Versioning is not supported on this account."));
                }
                if (this.getVersionId() != null) break;
                behaviorClient = this.getVersionClient(properties.getVersionId());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("Concurrency control type " + (Object)((Object)consistentReadControl) + " not supported."));
            }
        }
        StorageSeekableByteChannelBlobReadBehavior behavior = new StorageSeekableByteChannelBlobReadBehavior(behaviorClient, initialRange, initialPosition, properties.getBlobSize(), requestConditions);
        StorageSeekableByteChannel channel = new StorageSeekableByteChannel(chunkSize, behavior, initialPosition);
        return new BlobSeekableByteChannelReadResult(channel, properties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.existsWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, pollInterval);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration pollInterval) {
        return this.beginCopy(new BlobBeginCopyOptions(sourceUrl).setMetadata(metadata).setTier(tier).setRehydratePriority(priority).setSourceRequestConditions(ModelHelper.populateBlobSourceRequestConditions(sourceModifiedRequestConditions)).setDestinationRequestConditions(destRequestConditions).setPollInterval(pollInterval));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public SyncPoller<BlobCopyInfo, Void> beginCopy(BlobBeginCopyOptions options) {
        return this.client.beginCopy(options).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopyFromUrl(String copyId) {
        this.abortCopyFromUrlWithResponse(copyId, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyFromUrlWithResponse(String copyId, String leaseId, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.abortCopyFromUrlWithResponse(copyId, leaseId, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String copyFromUrl(String copySource) {
        return this.copyFromUrlWithResponse(copySource, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration timeout, Context context) {
        return this.copyFromUrlWithResponse(new BlobCopyFromUrlOptions(copySource).setMetadata(metadata).setTier(tier).setSourceRequestConditions(sourceModifiedRequestConditions).setDestinationRequestConditions(destRequestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> copyFromUrlWithResponse(BlobCopyFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<String>> response = this.client.copyFromUrlWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void download(OutputStream stream) {
        this.downloadStream(stream);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadStream(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData downloadContent() {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.downloadContent(), null);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        return this.downloadStreamWithResponse(stream, range, options, requestConditions, getRangeContentMd5, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadStreamWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull("stream", stream);
        Mono download = this.client.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)response.getValue(), stream).thenReturn(new BlobDownloadResponse((BlobDownloadAsyncResponse)response)));
        return (BlobDownloadResponse)StorageImplUtils.blockWithOptionalTimeout(download, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadContentResponse downloadContentWithResponse(DownloadRetryOptions options, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<BlobDownloadContentResponse> download = this.client.downloadStreamWithResponse(null, options, requestConditions, false, context).flatMap(r -> BinaryData.fromFlux((Flux)r.getValue()).map(data -> new BlobDownloadContentAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), (BinaryData)data, (BlobDownloadHeaders)r.getDeserializedHeaders()))).map(BlobDownloadContentResponse::new);
        return StorageImplUtils.blockWithOptionalTimeout(download, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions(ModelHelper.populateAndApplyDefaults(parallelTransferOptions));
        return this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(downloadRetryOptions).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(BlobDownloadToFileOptions options, Duration timeout, Context context) {
        Mono<Response<BlobProperties>> download = this.client.downloadToFileWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(download, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.deleteIfExistsWithResponse(deleteBlobSnapshotOptions, requestConditions, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties getProperties() {
        return this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> getPropertiesWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<BlobProperties>> response = this.client.getPropertiesWithResponse(requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setHttpHeaders(BlobHttpHeaders headers) {
        this.setHttpHeadersWithResponse(headers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setHttpHeadersWithResponse(headers, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, String> getTags() {
        return this.getTagsWithResponse(new BlobGetTagsOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, String>> getTagsWithResponse(BlobGetTagsOptions options, Duration timeout, Context context) {
        Mono<Response<Map<String, String>>> response = this.client.getTagsWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setTags(Map<String, String> tags) {
        this.setTagsWithResponse(new BlobSetTagsOptions(tags), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setTagsWithResponse(BlobSetTagsOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setTagsWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobClientBase createSnapshot() {
        return this.createSnapshotWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobClientBase> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response> response = this.client.createSnapshotWithResponse(metadata, requestConditions, context).map(rb -> new SimpleResponse<BlobClientBase>((Response<?>)rb, new BlobClientBase((BlobAsyncClientBase)rb.getValue())));
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessTier(AccessTier tier) {
        this.setAccessTierWithResponse(tier, null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId, Duration timeout, Context context) {
        return this.setAccessTierWithResponse(new BlobSetAccessTierOptions(tier).setPriority(priority).setLeaseId(leaseId), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessTierWithResponse(BlobSetAccessTierOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.client.setTierWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void undelete() {
        this.undeleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> undeleteWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.undeleteWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo() {
        return this.getAccountInfoWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Mono<Response<StorageAccountInfo>> response = this.client.getAccountInfoWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.client.generateSas(blobServiceSasSignatureValues);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.client.generateSas(blobServiceSasSignatureValues, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream openQueryInputStream(String expression) {
        return this.openQueryInputStreamWithResponse(new BlobQueryOptions(expression)).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InputStream> openQueryInputStreamWithResponse(BlobQueryOptions queryOptions) {
        BlobQueryAsyncResponse response = this.client.queryWithResponse(queryOptions).block();
        if (response == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Query response cannot be null"));
        }
        return new ResponseBase<BlobQueryHeaders, FluxInputStream>(response.getRequest(), response.getStatusCode(), response.getHeaders(), new FluxInputStream((Flux)response.getValue()), (BlobQueryHeaders)response.getDeserializedHeaders());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void query(OutputStream stream, String expression) {
        this.queryWithResponse(new BlobQueryOptions(expression, stream), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobQueryResponse queryWithResponse(BlobQueryOptions queryOptions, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull("options", queryOptions);
        StorageImplUtils.assertNotNull("outputStream", queryOptions.getOutputStream());
        Mono download = this.client.queryWithResponse(queryOptions, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)response.getValue(), queryOptions.getOutputStream()).thenReturn(new BlobQueryResponse((BlobQueryAsyncResponse)response)));
        return (BlobQueryResponse)StorageImplUtils.blockWithOptionalTimeout(download, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobImmutabilityPolicy setImmutabilityPolicy(BlobImmutabilityPolicy immutabilityPolicy) {
        return this.setImmutabilityPolicyWithResponse(immutabilityPolicy, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobImmutabilityPolicy> setImmutabilityPolicyWithResponse(BlobImmutabilityPolicy immutabilityPolicy, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<BlobImmutabilityPolicy>> response = this.client.setImmutabilityPolicyWithResponse(immutabilityPolicy, requestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteImmutabilityPolicy() {
        this.deleteImmutabilityPolicyWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteImmutabilityPolicyWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteImmutabilityPolicyWithResponse(context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobLegalHoldResult setLegalHold(boolean legalHold) {
        return this.setLegalHoldWithResponse(legalHold, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobLegalHoldResult> setLegalHoldWithResponse(boolean legalHold, Duration timeout, Context context) {
        Mono<Response<BlobLegalHoldResult>> response = this.client.setLegalHoldWithResponse(legalHold, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }
}

