/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.implementation.models.PageListHelper;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.pinot.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonDeserializer;

final class PageListDeserializer
extends JsonDeserializer<PageList> {
    PageListDeserializer() {
    }

    @Override
    public PageList getNullValue(DeserializationContext ctxt) {
        return new PageList();
    }

    @Override
    public PageList deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<PageRange> pageRanges = new ArrayList<PageRange>();
        ArrayList<ClearRange> clearRanges = new ArrayList<ClearRange>();
        String nextMarker = null;
        JsonDeserializer<Object> pageRangeDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(PageRange.class));
        JsonDeserializer<Object> clearRangeDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(ClearRange.class));
        JsonToken currentToken = p.nextToken();
        while (currentToken.id() != 2) {
            p.nextToken();
            if (p.getCurrentName().equals("PageRange")) {
                pageRanges.add((PageRange)pageRangeDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("ClearRange")) {
                clearRanges.add((ClearRange)clearRangeDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("NextMarker")) {
                nextMarker = "null".equals(p.getText()) ? null : p.getText();
            }
            currentToken = p.nextToken();
        }
        return PageListHelper.setNextMarker(new PageList().setPageRange(pageRanges).setClearRange(clearRanges), nextMarker);
    }
}

