/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.models.BlobAnalyticsLogging;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobMetrics;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.StaticWebsite;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="StorageServiceProperties")
public final class BlobServiceProperties {
    @JsonProperty(value="Logging")
    private BlobAnalyticsLogging logging;
    @JsonProperty(value="HourMetrics")
    private BlobMetrics hourMetrics;
    @JsonProperty(value="MinuteMetrics")
    private BlobMetrics minuteMetrics;
    @JsonProperty(value="Cors")
    private CorsWrapper cors;
    @JsonProperty(value="DefaultServiceVersion")
    private String defaultServiceVersion;
    @JsonProperty(value="DeleteRetentionPolicy")
    private BlobRetentionPolicy deleteRetentionPolicy;
    @JsonProperty(value="StaticWebsite")
    private StaticWebsite staticWebsite;

    public BlobAnalyticsLogging getLogging() {
        return this.logging;
    }

    public BlobServiceProperties setLogging(BlobAnalyticsLogging logging) {
        this.logging = logging;
        return this;
    }

    public BlobMetrics getHourMetrics() {
        return this.hourMetrics;
    }

    public BlobServiceProperties setHourMetrics(BlobMetrics hourMetrics) {
        this.hourMetrics = hourMetrics;
        return this;
    }

    public BlobMetrics getMinuteMetrics() {
        return this.minuteMetrics;
    }

    public BlobServiceProperties setMinuteMetrics(BlobMetrics minuteMetrics) {
        this.minuteMetrics = minuteMetrics;
        return this;
    }

    public List<BlobCorsRule> getCors() {
        if (this.cors == null) {
            this.cors = new CorsWrapper(new ArrayList());
        }
        return this.cors.items;
    }

    public BlobServiceProperties setCors(List<BlobCorsRule> cors) {
        this.cors = new CorsWrapper(cors);
        return this;
    }

    public String getDefaultServiceVersion() {
        return this.defaultServiceVersion;
    }

    public BlobServiceProperties setDefaultServiceVersion(String defaultServiceVersion) {
        this.defaultServiceVersion = defaultServiceVersion;
        return this;
    }

    public BlobRetentionPolicy getDeleteRetentionPolicy() {
        return this.deleteRetentionPolicy;
    }

    public BlobServiceProperties setDeleteRetentionPolicy(BlobRetentionPolicy deleteRetentionPolicy) {
        this.deleteRetentionPolicy = deleteRetentionPolicy;
        return this;
    }

    public StaticWebsite getStaticWebsite() {
        return this.staticWebsite;
    }

    public BlobServiceProperties setStaticWebsite(StaticWebsite staticWebsite) {
        this.staticWebsite = staticWebsite;
        return this;
    }

    private static final class CorsWrapper {
        @JacksonXmlProperty(localName="CorsRule")
        private final List<BlobCorsRule> items;

        @JsonCreator
        private CorsWrapper(@JacksonXmlProperty(localName="CorsRule") List<BlobCorsRule> items) {
            this.items = items;
        }
    }
}

