/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.implementation.accesshelpers.BlobItemConstructorProxy;
import com.azure.storage.blob.implementation.accesshelpers.BlobItemPropertiesConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobItemInternal;
import com.azure.storage.blob.implementation.models.BlobName;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobItemProperties;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import java.util.List;
import java.util.Map;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="Blob")
public final class BlobItem {
    @JsonUnwrapped
    private final BlobItemInternal blobItemInternal;
    @JsonIgnore
    private String convertedName;
    @JsonIgnore
    private BlobItemProperties convertedProperties;
    @JsonIgnore
    private Map<String, String> convertedTags;
    @JsonIgnore
    private List<ObjectReplicationPolicy> convertedObjectReplicationSourcePolicies;

    private BlobItem(BlobItemInternal blobItemInternal) {
        this.blobItemInternal = blobItemInternal;
    }

    public BlobItem() {
        this.blobItemInternal = new BlobItemInternal();
    }

    public String getName() {
        if (this.convertedName == null) {
            this.convertedName = ModelHelper.toBlobNameString(this.blobItemInternal.getName());
        }
        return this.convertedName;
    }

    public BlobItem setName(String name) {
        this.convertedName = name;
        this.blobItemInternal.setName(new BlobName().setContent(name));
        return this;
    }

    public boolean isDeleted() {
        return this.blobItemInternal.isDeleted();
    }

    public BlobItem setDeleted(boolean deleted) {
        this.blobItemInternal.setDeleted(deleted);
        return this;
    }

    public String getSnapshot() {
        return this.blobItemInternal.getSnapshot();
    }

    public BlobItem setSnapshot(String snapshot) {
        this.blobItemInternal.setSnapshot(snapshot);
        return this;
    }

    public BlobItemProperties getProperties() {
        if (this.convertedProperties == null) {
            this.convertedProperties = BlobItemPropertiesConstructorProxy.create(this.blobItemInternal.getProperties());
        }
        return this.convertedProperties;
    }

    public BlobItem setProperties(BlobItemProperties properties) {
        this.convertedProperties = properties;
        this.blobItemInternal.setProperties(BlobItemPropertiesConstructorProxy.getInternalProperties(properties));
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.blobItemInternal.getMetadata();
    }

    public BlobItem setMetadata(Map<String, String> metadata) {
        this.blobItemInternal.setMetadata(metadata);
        return this;
    }

    public Map<String, String> getTags() {
        if (this.convertedTags == null) {
            this.convertedTags = ModelHelper.tagMapFromBlobTags(this.blobItemInternal.getBlobTags());
        }
        return this.convertedTags;
    }

    public BlobItem setTags(Map<String, String> tags) {
        this.convertedTags = tags;
        this.blobItemInternal.setBlobTags(ModelHelper.toBlobTags(tags));
        return this;
    }

    public String getVersionId() {
        return this.blobItemInternal.getVersionId();
    }

    public BlobItem setVersionId(String versionId) {
        this.blobItemInternal.setVersionId(versionId);
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.blobItemInternal.isCurrentVersion();
    }

    public BlobItem setCurrentVersion(Boolean isCurrentVersion) {
        this.blobItemInternal.setIsCurrentVersion(isCurrentVersion);
        return this;
    }

    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        if (this.convertedObjectReplicationSourcePolicies == null) {
            this.convertedObjectReplicationSourcePolicies = ModelHelper.transformObjectReplicationMetadata(this.blobItemInternal.getObjectReplicationMetadata());
        }
        return this.convertedObjectReplicationSourcePolicies;
    }

    public BlobItem setObjectReplicationSourcePolicies(List<ObjectReplicationPolicy> objectReplicationSourcePolicies) {
        this.convertedObjectReplicationSourcePolicies = objectReplicationSourcePolicies;
        this.blobItemInternal.setObjectReplicationMetadata(ModelHelper.toObjectReplicationMetadata(objectReplicationSourcePolicies));
        return this;
    }

    public Boolean hasVersionsOnly() {
        return this.blobItemInternal.isHasVersionsOnly();
    }

    public BlobItem setHasVersionsOnly(Boolean hasVersionsOnly) {
        this.blobItemInternal.setHasVersionsOnly(hasVersionsOnly);
        return this;
    }

    public Boolean isPrefix() {
        return this.blobItemInternal.isPrefix() != null && this.blobItemInternal.isPrefix() != false;
    }

    public BlobItem setIsPrefix(Boolean isPrefix) {
        this.blobItemInternal.setIsPrefix(isPrefix);
        return this;
    }

    static {
        BlobItemConstructorProxy.setAccessor(BlobItem::new);
    }
}

