/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.CopyStatusType;
import java.time.OffsetDateTime;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JacksonXmlRootElement(localName="null")
public final class PageBlobsCopyIncrementalHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-copy-id")
    private String xMsCopyId;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType xMsCopyStatus;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");
    private static final HttpHeaderName X_MS_COPY_ID = HttpHeaderName.fromString("x-ms-copy-id");
    private static final HttpHeaderName X_MS_COPY_STATUS = HttpHeaderName.fromString("x-ms-copy-status");
    private static final HttpHeaderName X_MS_REQUEST_ID = HttpHeaderName.fromString("x-ms-request-id");

    public PageBlobsCopyIncrementalHeaders(HttpHeaders rawHeaders) {
        String xMsCopyStatus;
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.xMsCopyId = rawHeaders.getValue(X_MS_COPY_ID);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        if (lastModified != null) {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        if ((xMsCopyStatus = rawHeaders.getValue(X_MS_COPY_STATUS)) != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(xMsCopyStatus);
        }
        this.xMsRequestId = rawHeaders.getValue(X_MS_REQUEST_ID);
        this.xMsClientRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PageBlobsCopyIncrementalHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public PageBlobsCopyIncrementalHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PageBlobsCopyIncrementalHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PageBlobsCopyIncrementalHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public PageBlobsCopyIncrementalHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PageBlobsCopyIncrementalHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public PageBlobsCopyIncrementalHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PageBlobsCopyIncrementalHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

