/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AuthenticationRecord;
import com.azure.identity.AuthenticationRequiredException;
import com.azure.identity.AzureAuthorityHosts;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.MsalAuthenticationAccount;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.util.LoggingUtil;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

public class InteractiveBrowserCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(InteractiveBrowserCredential.class);
    private final Integer port;
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;
    private final AtomicReference<MsalAuthenticationAccount> cachedToken;
    private final boolean automaticAuthentication;
    private final String authorityHost;
    private final String redirectUrl;
    private final String loginHint;

    InteractiveBrowserCredential(String clientId, String tenantId, Integer port, String redirectUrl, boolean automaticAuthentication, String loginHint, IdentityClientOptions identityClientOptions) {
        this.port = port;
        this.redirectUrl = redirectUrl;
        IdentityClientBuilder builder = new IdentityClientBuilder().tenantId(tenantId).clientId(clientId).identityClientOptions(identityClientOptions);
        this.identityClient = builder.build();
        this.identitySyncClient = builder.buildSyncClient();
        this.cachedToken = new AtomicReference();
        this.authorityHost = identityClientOptions.getAuthorityHost();
        this.automaticAuthentication = automaticAuthentication;
        this.loginHint = loginHint;
        if (identityClientOptions.getAuthenticationRecord() != null) {
            this.cachedToken.set(new MsalAuthenticationAccount(identityClientOptions.getAuthenticationRecord()));
        }
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            if (!this.automaticAuthentication) {
                return Mono.error(LOGGER.logExceptionAsError(new AuthenticationRequiredException("Interactive authentication is needed to acquire token. Call Authenticate to initiate the device code authentication.", request)));
            }
            return this.identityClient.authenticateWithBrowserInteraction(request, this.port, this.redirectUrl, this.loginHint);
        })).map(this::updateCache).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, error));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        if (this.cachedToken.get() != null) {
            try {
                return this.identitySyncClient.authenticateWithPublicClientCache(request, this.cachedToken.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (!this.automaticAuthentication) {
                throw LOGGER.logExceptionAsError(new AuthenticationRequiredException("Interactive authentication is needed to acquire token. Call Authenticate to initiate the device code authentication.", request));
            }
            MsalToken accessToken = this.identitySyncClient.authenticateWithBrowserInteraction(request, this.port, this.redirectUrl, this.loginHint);
            this.updateCache(accessToken);
            LoggingUtil.logTokenSuccess(LOGGER, request);
            return accessToken;
        }
        catch (Exception e) {
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, e);
            throw e;
        }
    }

    public Mono<AuthenticationRecord> authenticate(TokenRequestContext request) {
        return Mono.defer(() -> this.identityClient.authenticateWithBrowserInteraction(request, this.port, this.redirectUrl, this.loginHint)).map(this::updateCache).map(msalToken -> this.cachedToken.get().getAuthenticationRecord());
    }

    public Mono<AuthenticationRecord> authenticate() {
        String defaultScope = AzureAuthorityHosts.getDefaultScope(this.authorityHost);
        if (defaultScope == null) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClient.getIdentityClientOptions(), new CredentialUnavailableException("Authenticating in this environment requires specifying a TokenRequestContext.")));
        }
        return this.authenticate(new TokenRequestContext().addScopes(defaultScope));
    }

    private AccessToken updateCache(MsalToken msalToken) {
        this.cachedToken.set(new MsalAuthenticationAccount(new AuthenticationRecord(msalToken.getAuthenticationResult(), this.identityClient.getTenantId(), this.identityClient.getClientId()), msalToken.getAccount().getTenantProfiles()));
        return msalToken;
    }
}

