/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ChainedTokenCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ChainedTokenCredential.class);
    private final List<TokenCredential> credentials;
    private final String unavailableError = this.getClass().getSimpleName() + " authentication failed. ---> ";

    ChainedTokenCredential(List<TokenCredential> credentials) {
        this.credentials = Collections.unmodifiableList(credentials);
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        ArrayList exceptions = new ArrayList(4);
        return Flux.fromIterable(this.credentials).flatMap(p -> p.getToken(request).doOnNext(t -> LOGGER.info("Azure Identity => Attempted credential {} returns a token", p.getClass().getSimpleName())).onErrorResume(Exception.class, t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error(new ClientAuthenticationException(this.unavailableError + p.getClass().getSimpleName() + " authentication failed. Error Details: " + t.getMessage(), null, (Throwable)t));
            }
            exceptions.add((CredentialUnavailableException)t);
            LOGGER.info("Azure Identity => Attempted credential {} is unavailable.", p.getClass().getSimpleName());
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
                last = new CredentialUnavailableException(current.getMessage() + "\r\n" + last.getMessage() + (z == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
            }
            return Mono.error(last);
        }));
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        ArrayList<CredentialUnavailableException> exceptions = new ArrayList<CredentialUnavailableException>(4);
        for (TokenCredential credential : this.credentials) {
            try {
                return credential.getTokenSync(request);
            }
            catch (Exception e) {
                if (e.getClass() != CredentialUnavailableException.class) {
                    throw new ClientAuthenticationException(this.unavailableError + credential.getClass().getSimpleName() + " authentication failed. Error Details: " + e.getMessage(), null, e);
                }
                if (e instanceof CredentialUnavailableException) {
                    exceptions.add((CredentialUnavailableException)e);
                }
                LOGGER.info("Azure Identity => Attempted credential {} is unavailable.", credential.getClass().getSimpleName());
            }
        }
        CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
        for (int z = exceptions.size() - 2; z >= 0; --z) {
            CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
            last = new CredentialUnavailableException(current.getMessage() + "\r\n" + last.getMessage() + (z == 0 ? "To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azure-identity-java-default-azure-credential-troubleshoot" : ""));
        }
        throw last;
    }
}

