/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import reactor.core.publisher.Mono;

public final class AuthenticationRecord {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="authority")
    private String authority;
    @JsonProperty(value="homeAccountId")
    private String homeAccountId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="clientId")
    private String clientId;

    AuthenticationRecord() {
    }

    AuthenticationRecord(IAuthenticationResult authenticationResult, String tenantId, String clientId) {
        this.authority = authenticationResult.account().environment();
        this.homeAccountId = authenticationResult.account().homeAccountId();
        this.username = authenticationResult.account().username();
        this.tenantId = tenantId;
        this.clientId = clientId;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public Mono<OutputStream> serializeAsync(OutputStream outputStream) {
        return Mono.defer(() -> {
            try {
                OBJECT_MAPPER.writeValue(outputStream, (Object)this);
            }
            catch (IOException e) {
                return Mono.error(e);
            }
            return Mono.just(outputStream);
        });
    }

    public void serialize(OutputStream outputStream) {
        this.serializeAsync(outputStream).block();
    }

    public static Mono<AuthenticationRecord> deserializeAsync(InputStream inputStream) {
        return Mono.defer(() -> {
            AuthenticationRecord authenticationRecord;
            try {
                authenticationRecord = OBJECT_MAPPER.readValue(inputStream, AuthenticationRecord.class);
            }
            catch (IOException e) {
                return Mono.error(e);
            }
            return Mono.just(authenticationRecord);
        });
    }

    public static AuthenticationRecord deserialize(InputStream inputStream) {
        return AuthenticationRecord.deserializeAsync(inputStream).block();
    }
}

