/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling;

import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.implementation.PollingUtils;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class LocationPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ObjectSerializer DEFAULT_SERIALIZER = new DefaultJsonSerializer();
    private static final ClientLogger LOGGER = new ClientLogger(LocationPollingStrategy.class);
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final Context context;

    public LocationPollingStrategy(HttpPipeline httpPipeline) {
        this(httpPipeline, DEFAULT_SERIALIZER, Context.NONE);
    }

    public LocationPollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer) {
        this(httpPipeline, serializer, Context.NONE);
    }

    public LocationPollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, Context context) {
        this(httpPipeline, null, serializer, context);
    }

    public LocationPollingStrategy(HttpPipeline httpPipeline, String endpoint, ObjectSerializer serializer, Context context) {
        this.httpPipeline = Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null");
        this.endpoint = endpoint;
        this.serializer = serializer == null ? DEFAULT_SERIALIZER : serializer;
        this.context = context == null ? Context.NONE : context;
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        HttpHeader locationHeader = initialResponse.getHeaders().get(HttpHeaderName.LOCATION);
        if (locationHeader != null) {
            try {
                new URL(PollingUtils.getAbsolutePath(locationHeader.getValue(), this.endpoint, LOGGER));
                return Mono.just(true);
            }
            catch (MalformedURLException e) {
                LOGGER.info("Failed to parse Location header into a URL.", e);
                return Mono.just(false);
            }
        }
        return Mono.just(false);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader locationHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (locationHeader != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(locationHeader.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return PollingUtils.convertResponse(response.getValue(), this.serializer, pollResponseType).map(value -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, value, retryAfter)).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse<Object>(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter)));
        }
        return Mono.error(new AzureException(String.format("Operation failed or cancelled with status code %d,, 'Location' header: %s, and response body: %s", response.getStatusCode(), locationHeader, PollingUtils.serializeResponse(response.getValue(), this.serializer))));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, pollingContext.getData("Location"));
        return FluxUtil.withContext(context1 -> this.httpPipeline.send(request, CoreUtils.mergeContexts(context1, this.context))).flatMap(response -> {
            HttpHeader locationHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
            if (locationHeader != null) {
                pollingContext.setData("Location", locationHeader.getValue());
            }
            LongRunningOperationStatus status = response.getStatusCode() == 202 ? LongRunningOperationStatus.IN_PROGRESS : (response.getStatusCode() >= 200 && response.getStatusCode() <= 204 ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : LongRunningOperationStatus.FAILED);
            return response.getBodyAsByteArray().map(BinaryData::fromBytes).flatMap(binaryData -> {
                pollingContext.setData("pollResponseBody", binaryData.toString());
                Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
                return PollingUtils.deserializeResponse(binaryData, this.serializer, pollResponseType).map(value -> new PollResponse<Object>(status, value, retryAfter));
            });
        });
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        String finalGetUrl;
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error(new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error(new AzureException("Long running operation cancelled."));
        }
        String httpMethod = pollingContext.getData("httpMethod");
        if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
            finalGetUrl = pollingContext.getData("requestURL");
        } else if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod)) {
            finalGetUrl = pollingContext.getData("Location");
        } else {
            return Mono.error(new AzureException("Cannot get final result"));
        }
        if (finalGetUrl == null) {
            String latestResponseBody = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponse(BinaryData.fromString(latestResponseBody), this.serializer, resultType);
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, finalGetUrl);
        return FluxUtil.withContext(context1 -> this.httpPipeline.send(request, CoreUtils.mergeContexts(context1, this.context))).flatMap(HttpResponse::getBodyAsByteArray).map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, resultType));
    }
}

