/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.implementation.AsynchronousByteChannelWriteSubscriber;
import com.azure.core.implementation.ByteBufferCollector;
import com.azure.core.implementation.OutputStreamWriteSubscriber;
import com.azure.core.implementation.RetriableDownloadFlux;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.io.IOUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public final class FluxUtil {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ClientLogger LOGGER = new ClientLogger(FluxUtil.class);
    private static final int DEFAULT_CHUNK_SIZE = 65536;

    public static boolean isFluxByteBuffer(Type entityType) {
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Flux.class)) {
            Type innerType = TypeUtil.getTypeArguments(entityType)[0];
            return TypeUtil.isTypeOrSubTypeOf(innerType, ByteBuffer.class);
        }
        return false;
    }

    public static Flux<ByteBuffer> addProgressReporting(Flux<ByteBuffer> flux, ProgressReporter progressReporter) {
        if (progressReporter == null) {
            return flux;
        }
        return Mono.just(progressReporter).flatMapMany(reporter -> {
            reporter.reset();
            return flux.doOnNext(buffer -> reporter.reportProgress(buffer.remaining()));
        });
    }

    public static Mono<byte[]> collectBytesInByteBufferStream(Flux<ByteBuffer> stream) {
        return stream.collect(ByteBufferCollector::new, ByteBufferCollector::write).map(ByteBufferCollector::toByteArray);
    }

    public static Mono<byte[]> collectBytesInByteBufferStream(Flux<ByteBuffer> stream, int sizeHint) {
        return stream.collect(() -> new ByteBufferCollector(sizeHint), ByteBufferCollector::write).map(ByteBufferCollector::toByteArray);
    }

    public static Mono<byte[]> collectBytesFromNetworkResponse(Flux<ByteBuffer> stream, HttpHeaders headers) {
        Objects.requireNonNull(headers, "'headers' cannot be null.");
        String contentLengthHeader = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        if (contentLengthHeader == null) {
            return FluxUtil.collectBytesInByteBufferStream(stream);
        }
        try {
            int contentLength = Integer.parseInt(contentLengthHeader);
            if (contentLength > 0) {
                return FluxUtil.collectBytesInByteBufferStream(stream, contentLength);
            }
            return Mono.just(EMPTY_BYTE_ARRAY);
        }
        catch (NumberFormatException ex) {
            return FluxUtil.collectBytesInByteBufferStream(stream);
        }
    }

    public static byte[] byteBufferToArray(ByteBuffer byteBuffer) {
        int length = byteBuffer.remaining();
        byte[] byteArray = new byte[length];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    public static Flux<ByteBuffer> createRetriableDownloadFlux(Supplier<Flux<ByteBuffer>> downloadSupplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume, int maxRetries) {
        return FluxUtil.createRetriableDownloadFlux(downloadSupplier, onDownloadErrorResume, maxRetries, 0L);
    }

    public static Flux<ByteBuffer> createRetriableDownloadFlux(Supplier<Flux<ByteBuffer>> downloadSupplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume, int maxRetries, long position) {
        return new RetriableDownloadFlux(downloadSupplier, onDownloadErrorResume, maxRetries, position);
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
        return FluxUtil.toFluxByteBuffer(inputStream, 4096);
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream, int chunkSize) {
        if (chunkSize <= 0) {
            return Flux.error(new IllegalArgumentException("'chunkSize' must be greater than 0."));
        }
        if (inputStream == null) {
            return Flux.empty();
        }
        if (inputStream instanceof FileInputStream) {
            FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
            return Flux.generate(() -> fileChannel, (channel, sink) -> {
                try {
                    long channelPosition = channel.position();
                    long channelSize = channel.size();
                    if (channelPosition == channelSize) {
                        channel.close();
                        sink.complete();
                    } else {
                        int nextByteBufferSize = (int)Math.min((long)chunkSize, channelSize - channelPosition);
                        sink.next(channel.map(FileChannel.MapMode.READ_ONLY, channelPosition, nextByteBufferSize));
                        channel.position(channelPosition + (long)nextByteBufferSize);
                    }
                }
                catch (IOException ex) {
                    sink.error(ex);
                }
                return channel;
            });
        }
        return Flux.generate(() -> inputStream, (stream, sink) -> {
            byte[] buffer = new byte[chunkSize];
            try {
                int readCount;
                for (int offset = 0; offset < chunkSize; offset += readCount) {
                    readCount = inputStream.read(buffer, offset, chunkSize - offset);
                    if (readCount != -1) continue;
                    if (offset > 0) {
                        sink.next(ByteBuffer.wrap(buffer, 0, offset));
                    }
                    sink.complete();
                    return stream;
                }
                sink.next(ByteBuffer.wrap(buffer));
            }
            catch (IOException ex) {
                sink.error(ex);
            }
            return stream;
        }).filter(Buffer::hasRemaining);
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> serviceCall) {
        return FluxUtil.withContext(serviceCall, Collections.emptyMap());
    }

    public static <T> Mono<T> withContext(Function<Context, Mono<T>> serviceCall, Map<String, String> contextAttributes) {
        return Mono.deferContextual(context -> {
            Context[] azureContext = new Context[]{Context.NONE};
            if (!CoreUtils.isNullOrEmpty(contextAttributes)) {
                contextAttributes.forEach((key, value) -> {
                    azureContext[0] = azureContext[0].addData(key, value);
                });
            }
            if (!context.isEmpty()) {
                context.stream().forEach(entry -> {
                    azureContext[0] = azureContext[0].addData(entry.getKey(), entry.getValue());
                });
            }
            return (Mono)serviceCall.apply(azureContext[0]);
        });
    }

    public static <T> Mono<T> toMono(Response<T> response) {
        return Mono.justOrEmpty(response.getValue());
    }

    public static <T> Mono<T> monoError(ClientLogger logger, RuntimeException ex) {
        return Mono.error(logger.logExceptionAsError(Exceptions.propagate(ex)));
    }

    public static <T> Mono<T> monoError(LoggingEventBuilder logBuilder, RuntimeException ex) {
        return Mono.error(logBuilder.log(Exceptions.propagate(ex)));
    }

    public static <T> Flux<T> fluxError(ClientLogger logger, RuntimeException ex) {
        return Flux.error(logger.logExceptionAsError(Exceptions.propagate(ex)));
    }

    public static <T> PagedFlux<T> pagedFluxError(ClientLogger logger, RuntimeException ex) {
        return new PagedFlux(() -> FluxUtil.monoError(logger, ex));
    }

    public static <T> Flux<T> fluxContext(Function<Context, Flux<T>> serviceCall) {
        return Flux.deferContextual(context -> (Publisher)serviceCall.apply(FluxUtil.toAzureContext(context)));
    }

    private static Context toAzureContext(ContextView context) {
        Context[] azureContext = new Context[]{Context.NONE};
        if (!context.isEmpty()) {
            context.stream().forEach(entry -> {
                azureContext[0] = azureContext[0].addData(entry.getKey(), entry.getValue());
            });
        }
        return azureContext[0];
    }

    public static reactor.util.context.Context toReactorContext(Context context) {
        Context[] contextChain;
        if (context == null) {
            return reactor.util.context.Context.empty();
        }
        reactor.util.context.Context returnContext = reactor.util.context.Context.empty();
        for (Context toAdd : contextChain = context.getContextChain()) {
            if (toAdd == null || toAdd.getValue() == null) continue;
            returnContext = returnContext.put(toAdd.getKey(), toAdd.getValue());
        }
        return returnContext;
    }

    public static Mono<Void> writeToOutputStream(Flux<ByteBuffer> content, OutputStream stream) {
        if (content == null && stream == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'stream' cannot be null."));
        }
        if (content == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (stream == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'stream' cannot be null."));
        }
        return Mono.create(emitter -> content.subscribe(new OutputStreamWriteSubscriber((MonoSink<Void>)emitter, stream, LOGGER)));
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> content, AsynchronousFileChannel outFile) {
        return FluxUtil.writeFile(content, outFile, 0L);
    }

    public static Mono<Void> writeFile(Flux<ByteBuffer> content, AsynchronousFileChannel outFile, long position) {
        if (content == null && outFile == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'outFile' cannot be null."));
        }
        if (content == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (outFile == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'outFile' cannot be null."));
        }
        if (position < 0L) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalArgumentException("'position' cannot be less than 0."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(content, IOUtils.toAsynchronousByteChannel(outFile, position));
    }

    public static Mono<Void> writeToAsynchronousByteChannel(Flux<ByteBuffer> content, AsynchronousByteChannel channel) {
        if (content == null && channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'channel' cannot be null."));
        }
        if (content == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return Mono.create(emitter -> content.subscribe(new AsynchronousByteChannelWriteSubscriber(channel, (MonoSink<Void>)emitter)));
    }

    public static Mono<Void> writeToWritableByteChannel(Flux<ByteBuffer> content, WritableByteChannel channel) {
        if (content == null && channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' and 'channel' cannot be null."));
        }
        if (content == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'content' cannot be null."));
        }
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return content.publishOn(Schedulers.boundedElastic()).map(buffer -> {
            while (buffer.hasRemaining()) {
                try {
                    channel.write((ByteBuffer)buffer);
                }
                catch (IOException e) {
                    throw Exceptions.propagate(e);
                }
            }
            return buffer;
        }).then();
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
        return new FileReadFlux(fileChannel, chunkSize, offset, length);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel, long offset, long length) {
        return FluxUtil.readFile(fileChannel, 65536, offset, length);
    }

    public static Flux<ByteBuffer> readFile(AsynchronousFileChannel fileChannel) {
        try {
            long size = fileChannel.size();
            return FluxUtil.readFile(fileChannel, 65536, 0L, size);
        }
        catch (IOException e) {
            return Flux.error(new RuntimeException("Failed to read the file.", e));
        }
    }

    private FluxUtil() {
    }

    private static final class FileReadFlux
    extends Flux<ByteBuffer> {
        private final AsynchronousFileChannel fileChannel;
        private final int chunkSize;
        private final long offset;
        private final long length;

        FileReadFlux(AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
            this.fileChannel = fileChannel;
            this.chunkSize = chunkSize;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
            FileReadSubscription subscription = new FileReadSubscription(actual, this.fileChannel, this.chunkSize, this.offset, this.length);
            actual.onSubscribe(subscription);
        }

        static final class FileReadSubscription
        implements Subscription,
        CompletionHandler<Integer, ByteBuffer> {
            private static final int NOT_SET = -1;
            private static final long serialVersionUID = -6831808726875304256L;
            private final Subscriber<? super ByteBuffer> subscriber;
            private volatile long position;
            private final AsynchronousFileChannel fileChannel;
            private final int chunkSize;
            private final long offset;
            private final long length;
            private volatile boolean done;
            private Throwable error;
            private volatile ByteBuffer next;
            private volatile boolean cancelled;
            volatile int wip;
            static final AtomicIntegerFieldUpdater<FileReadSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(FileReadSubscription.class, "wip");
            volatile long requested;
            static final AtomicLongFieldUpdater<FileReadSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(FileReadSubscription.class, "requested");

            FileReadSubscription(Subscriber<? super ByteBuffer> subscriber, AsynchronousFileChannel fileChannel, int chunkSize, long offset, long length) {
                this.subscriber = subscriber;
                this.fileChannel = fileChannel;
                this.chunkSize = chunkSize;
                this.offset = offset;
                this.length = length;
                this.position = -1L;
            }

            @Override
            public void request(long n) {
                if (Operators.validate(n)) {
                    Operators.addCap(REQUESTED, this, n);
                    this.drain();
                }
            }

            @Override
            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void completed(Integer bytesRead, ByteBuffer buffer) {
                if (!this.cancelled) {
                    if (bytesRead == -1) {
                        this.done = true;
                    } else {
                        long position2;
                        long pos = this.position;
                        int bytesWanted = Math.min(bytesRead, this.maxRequired(pos));
                        this.position = position2 = pos + (long)bytesWanted;
                        buffer.position(bytesWanted);
                        buffer.flip();
                        this.next = buffer;
                        if (position2 >= this.offset + this.length) {
                            this.done = true;
                        }
                    }
                    this.drain();
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuffer attachment) {
                if (!this.cancelled) {
                    this.error = exc;
                    this.done = true;
                    this.drain();
                }
            }

            private void drain() {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.position == -1L) {
                    this.position = this.offset;
                    this.doRead();
                }
                int missed = 1;
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (REQUESTED.get(this) <= 0L) continue;
                    boolean emitted = false;
                    boolean d = this.done;
                    ByteBuffer bb = this.next;
                    if (bb != null) {
                        this.next = null;
                        this.subscriber.onNext(bb);
                        emitted = true;
                    }
                    if (d) {
                        if (this.error != null) {
                            this.subscriber.onError(this.error);
                        } else {
                            this.subscriber.onComplete();
                        }
                        return;
                    }
                    if (!emitted) continue;
                    Operators.produced(REQUESTED, this, 1L);
                    this.doRead();
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }

            private void doRead() {
                long pos = this.position;
                ByteBuffer innerBuf = ByteBuffer.allocate(Math.min(this.chunkSize, this.maxRequired(pos)));
                this.fileChannel.read(innerBuf, pos, innerBuf, this);
            }

            private int maxRequired(long pos) {
                long maxRequired = this.offset + this.length - pos;
                if (maxRequired <= 0L) {
                    return 0;
                }
                int m = (int)maxRequired;
                if (m < 0) {
                    return Integer.MAX_VALUE;
                }
                return m;
            }
        }
    }
}

