/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataContentType;
import com.azure.core.implementation.util.IterableOfByteBuffersInputStream;
import com.azure.core.implementation.util.StreamUtil;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class InputStreamContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(InputStreamContent.class);
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 8192;
    private static final int MAX_BUFFER_CHUNK_SIZE = 0x800000;
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private final Supplier<InputStream> content;
    private final Long length;
    private final boolean isReplayable;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<InputStreamContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InputStreamContent.class, byte[].class, "bytes");

    public InputStreamContent(InputStream inputStream, Long length) {
        Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        this.content = () -> inputStream;
        this.length = length;
        this.isReplayable = false;
    }

    private InputStreamContent(Supplier<InputStream> inputStreamSupplier, Long length, boolean isReplayable) {
        this.content = Objects.requireNonNull(inputStreamSupplier, "'inputStreamSupplier' cannot be null.");
        this.length = length;
        this.isReplayable = isReplayable;
    }

    @Override
    public Long getLength() {
        byte[] data = BYTES_UPDATER.get(this);
        if (data != null) {
            return data.length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return this.content.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return FluxUtil.toFluxByteBuffer(this.content.get(), 8192);
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        InputStream inputStream = this.content.get();
        if (InputStreamContent.canMarkReset(inputStream, this.length)) {
            return InputStreamContent.createMarkResetContent(inputStream, this.length);
        }
        return InputStreamContent.readAndBuffer(inputStream, this.length);
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        if (this.isReplayable) {
            return Mono.just(this);
        }
        InputStream inputStream = this.content.get();
        if (InputStreamContent.canMarkReset(inputStream, this.length)) {
            return Mono.fromCallable(() -> InputStreamContent.createMarkResetContent(inputStream, this.length));
        }
        return Mono.just(inputStream).publishOn(Schedulers.boundedElastic()).map(is -> InputStreamContent.readAndBuffer(is, this.length));
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private static boolean canMarkReset(InputStream inputStream, Long length) {
        return length != null && length < 0x7FFFFFF7L && inputStream.markSupported();
    }

    private static InputStreamContent createMarkResetContent(InputStream inputStream, Long length) {
        inputStream.mark(length.intValue());
        return new InputStreamContent(() -> {
            try {
                inputStream.reset();
                return inputStream;
            }
            catch (IOException e) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
            }
        }, length, true);
    }

    private static InputStreamContent readAndBuffer(InputStream inputStream, Long length) {
        try {
            List<ByteBuffer> byteBuffers = StreamUtil.readStreamToListOfByteBuffers(inputStream, length, 8192, 0x800000);
            return new InputStreamContent(() -> new IterableOfByteBuffersInputStream(byteBuffers), length, true);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    private byte[] getBytes() {
        try {
            int nRead;
            ByteArrayOutputStream dataOutputBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            InputStream inputStream = this.content.get();
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return dataOutputBuffer.toByteArray();
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }
}

