/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.jackson.AdditionalPropertiesDeserializer;
import com.azure.core.implementation.jackson.AdditionalPropertiesSerializer;
import com.azure.core.implementation.jackson.Base64UrlSerializer;
import com.azure.core.implementation.jackson.BinaryDataDeserializer;
import com.azure.core.implementation.jackson.BinaryDataSerializer;
import com.azure.core.implementation.jackson.ByteArraySerializer;
import com.azure.core.implementation.jackson.DateTimeDeserializer;
import com.azure.core.implementation.jackson.DateTimeRfc1123Serializer;
import com.azure.core.implementation.jackson.DateTimeSerializer;
import com.azure.core.implementation.jackson.DurationSerializer;
import com.azure.core.implementation.jackson.FlatteningDeserializer;
import com.azure.core.implementation.jackson.FlatteningSerializer;
import com.azure.core.implementation.jackson.GeoJsonDeserializer;
import com.azure.core.implementation.jackson.GeoJsonSerializer;
import com.azure.core.implementation.jackson.HttpHeadersSerializer;
import com.azure.core.implementation.jackson.XmlMapperFactory;
import com.azure.core.util.logging.ClientLogger;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.PropertyAccessor;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.json.JsonMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

final class ObjectMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectMapperFactory.class);
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    ObjectMapperFactory() {
    }

    public ObjectMapper createJsonMapper(ObjectMapper innerMapper) {
        Object flatteningMapper = ((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(FlatteningSerializer.getModule(innerMapper))).addModule(FlatteningDeserializer.getModule(innerMapper))).build();
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule(AdditionalPropertiesSerializer.getModule(flatteningMapper))).addModule(AdditionalPropertiesDeserializer.getModule(flatteningMapper))).addModule(FlatteningSerializer.getModule(innerMapper))).addModule(FlatteningDeserializer.getModule(innerMapper))).build();
    }

    public ObjectMapper createXmlMapper() {
        return XmlMapperFactory.INSTANCE.createXmlMapper();
    }

    public ObjectMapper createSimpleMapper() {
        return ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).build();
    }

    public ObjectMapper createDefaultMapper() {
        return new ObjectMapper();
    }

    public ObjectMapper createPrettyPrintMapper() {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    }

    public ObjectMapper createHeaderMapper() {
        return ((JsonMapper.Builder)ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).build();
    }

    static <S extends MapperBuilder<?, ?>> S initializeMapperBuilder(S mapper) {
        ((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)((MapperBuilder)mapper.enable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule(new JavaTimeModule())).addModule(BinaryDataSerializer.getModule())).addModule(BinaryDataDeserializer.getModule())).addModule(ByteArraySerializer.getModule())).addModule(Base64UrlSerializer.getModule())).addModule(DateTimeSerializer.getModule())).addModule(DateTimeDeserializer.getModule())).addModule(DateTimeRfc1123Serializer.getModule())).addModule(DurationSerializer.getModule())).addModule(HttpHeadersSerializer.getModule())).addModule(GeoJsonSerializer.getModule())).addModule(GeoJsonDeserializer.getModule())).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return mapper;
    }
}

