/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CookiePolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(CookiePolicy.class);
    private final CookieHandler cookies = new CookieManager();
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            try {
                HttpRequest httpRequest = context.getHttpRequest();
                URI uri = httpRequest.getUrl().toURI();
                HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
                for (HttpHeader header : httpRequest.getHeaders()) {
                    cookieHeaders.put(header.getName(), header.getValuesList());
                }
                Map<String, List<String>> requestCookies = CookiePolicy.this.cookies.get(uri, cookieHeaders);
                for (Map.Entry<String, List<String>> entry : requestCookies.entrySet()) {
                    httpRequest.getHeaders().set(entry.getKey(), entry.getValue());
                }
            }
            catch (IOException | URISyntaxException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(e));
            }
        }

        @Override
        protected HttpResponse afterReceivedResponse(HttpPipelineCallContext context, HttpResponse response) {
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            for (HttpHeader header : response.getHeaders()) {
                responseHeaders.put(header.getName(), header.getValuesList());
            }
            try {
                URI uri = context.getHttpRequest().getUrl().toURI();
                CookiePolicy.this.cookies.put(uri, responseHeaders);
            }
            catch (IOException | URISyntaxException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate(e));
            }
            return response;
        }
    };

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

