/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.netty.implementation.DeferredCacheImmutableMap;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;
    private Map<String, String[]> abstractMultiMap;

    public NettyToAzureCoreHttpHeadersWrapper(org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    @Override
    public int getSize() {
        return this.nettyHeaders.size();
    }

    @Override
    public HttpHeaders add(String name, String value) {
        this.nettyHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders add(HttpHeaderName name, String value) {
        return this.add(name.getCaseSensitiveName(), value);
    }

    @Override
    public HttpHeaders set(String name, String value) {
        this.nettyHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders set(HttpHeaderName name, String value) {
        return this.set(name.getCaseSensitiveName(), value);
    }

    @Override
    public HttpHeaders set(String name, List<String> values) {
        this.nettyHeaders.set(name, (Iterable<?>)values);
        return this;
    }

    @Override
    public HttpHeaders set(HttpHeaderName name, List<String> values) {
        return this.set(name.getCaseSensitiveName(), values);
    }

    @Override
    public HttpHeader get(String name) {
        List<String> values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values) ? null : new NettyHttpHeader(this, name, values);
    }

    @Override
    public HttpHeader get(HttpHeaderName name) {
        return this.get(name.getCaseSensitiveName());
    }

    @Override
    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        if (header != null) {
            this.nettyHeaders.remove(name);
        }
        return header;
    }

    @Override
    public HttpHeader remove(HttpHeaderName name) {
        return this.remove(name.getCaseSensitiveName());
    }

    @Override
    public String getValue(String name) {
        List<String> values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values) ? null : CoreUtils.stringJoin(",", values);
    }

    @Override
    public String getValue(HttpHeaderName name) {
        return this.getValue(name.getCaseSensitiveName());
    }

    @Override
    public String[] getValues(String name) {
        List<String> values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values) ? null : values.toArray(new String[0]);
    }

    @Override
    public String[] getValues(HttpHeaderName name) {
        return this.getValues(name.getCaseSensitiveName());
    }

    @Override
    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new DeferredCacheImmutableMap<String>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> CoreUtils.stringJoin(",", getAll));
        }
        return this.abstractMap;
    }

    Map<String, String[]> toMultiMap() {
        if (this.abstractMultiMap == null) {
            this.abstractMultiMap = new DeferredCacheImmutableMap<String[]>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> getAll.toArray(new String[0]));
        }
        return this.abstractMultiMap;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return new NettyHeadersIterator(this);
    }

    @Override
    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll((String)name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values) {
            super(name, values);
            this.allHeaders = allHeaders;
        }

        @Override
        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }

    static final class NettyHeadersIterator
    implements Iterator<HttpHeader> {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;
        private final Iterator<String> headerNames;

        NettyHeadersIterator(NettyToAzureCoreHttpHeadersWrapper allHeaders) {
            this.allHeaders = allHeaders;
            this.headerNames = allHeaders.nettyHeaders.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.headerNames.hasNext();
        }

        @Override
        public NettyHttpHeader next() {
            String headerName = this.headerNames.next();
            return new NettyHttpHeader(this.allHeaders, headerName, this.allHeaders.nettyHeaders.getAll(headerName));
        }
    }
}

