/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.NettyToAzureCoreHttpHeadersWrapper;
import java.util.Iterator;
import java.util.Map;
import reactor.netty.http.client.HttpClientResponse;

public abstract class NettyAsyncHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse reactorNettyResponse;
    private final HttpHeaders headers;

    NettyAsyncHttpResponseBase(HttpClientResponse reactorNettyResponse, HttpRequest httpRequest, boolean headersEagerlyConverted) {
        super(httpRequest);
        this.reactorNettyResponse = reactorNettyResponse;
        org.apache.pinot.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders = reactorNettyResponse.responseHeaders();
        if (headersEagerlyConverted) {
            this.headers = new HttpHeaders((int)((float)nettyHeaders.size() / 0.75f));
            Iterator<Map.Entry<CharSequence, CharSequence>> nettyHeadersIterator = nettyHeaders.iteratorCharSequence();
            while (nettyHeadersIterator.hasNext()) {
                Map.Entry<CharSequence, CharSequence> next = nettyHeadersIterator.next();
                CharSequence value = next.getValue();
                this.headers.add(next.getKey().toString(), value == null ? null : value.toString());
            }
        } else {
            this.headers = new NettyToAzureCoreHttpHeadersWrapper(nettyHeaders);
        }
    }

    @Override
    public final int getStatusCode() {
        return this.reactorNettyResponse.status().code();
    }

    @Override
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

