/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractor;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractorConfig;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractor;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SimpleAvroMessageDecoder
implements StreamMessageDecoder<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleAvroMessageDecoder.class);
    private static final String SCHEMA = "schema";
    private Schema _avroSchema;
    private DatumReader<GenericData.Record> _datumReader;
    private RecordExtractor<GenericData.Record> _avroRecordExtractor;
    private BinaryDecoder _binaryDecoderToReuse;
    private GenericData.Record _avroRecordToReuse;

    public void init(Map<String, String> props, Set<String> fieldsToRead, String topicName) throws Exception {
        Preconditions.checkState((boolean)props.containsKey(SCHEMA), (Object)"Avro schema must be provided");
        this._avroSchema = new Schema.Parser().parse(props.get(SCHEMA));
        this._datumReader = new GenericDatumReader<GenericData.Record>(this._avroSchema);
        String recordExtractorClass = props.get("recordExtractorClass");
        String recordExtractorConfigClass = props.get("recordExtractorConfigClass");
        if (recordExtractorClass == null) {
            recordExtractorClass = AvroRecordExtractor.class.getName();
            recordExtractorConfigClass = AvroRecordExtractorConfig.class.getName();
        }
        RecordExtractorConfig config = null;
        if (recordExtractorConfigClass != null) {
            config = (RecordExtractorConfig)PluginManager.get().createInstance(recordExtractorConfigClass);
            config.init(props);
        }
        this._avroRecordExtractor = (RecordExtractor)PluginManager.get().createInstance(recordExtractorClass);
        this._avroRecordExtractor.init(fieldsToRead, config);
    }

    public GenericRow decode(byte[] payload, GenericRow destination) {
        return this.decode(payload, 0, payload.length, destination);
    }

    public GenericRow decode(byte[] payload, int offset, int length, GenericRow destination) {
        this._binaryDecoderToReuse = DecoderFactory.get().binaryDecoder(payload, offset, length, this._binaryDecoderToReuse);
        try {
            this._avroRecordToReuse = this._datumReader.read(this._avroRecordToReuse, this._binaryDecoderToReuse);
        }
        catch (IOException e) {
            LOGGER.error("Caught exception while reading message using schema: {}", (Object)this._avroSchema, (Object)e);
            return null;
        }
        return this._avroRecordExtractor.extract((Object)this._avroRecordToReuse, destination);
    }
}

