/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.snapshot;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.pinot.shaded.org.apache.kafka.common.record.FileRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.RecordBatch;
import org.apache.pinot.shaded.org.apache.kafka.common.record.UnalignedRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.Snapshots;

public final class FileRawSnapshotReader
implements RawSnapshotReader {
    private final FileRecords fileRecords;
    private final OffsetAndEpoch snapshotId;

    private FileRawSnapshotReader(FileRecords fileRecords, OffsetAndEpoch snapshotId) {
        this.fileRecords = fileRecords;
        this.snapshotId = snapshotId;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long sizeInBytes() {
        return this.fileRecords.sizeInBytes();
    }

    @Override
    public Iterator<RecordBatch> iterator() {
        return Utils.covariantCast(this.fileRecords.batchIterator());
    }

    @Override
    public UnalignedRecords read(long position, int size) {
        return this.fileRecords.sliceUnaligned(Math.toIntExact(position), size);
    }

    @Override
    public void close() throws IOException {
        this.fileRecords.close();
    }

    public static FileRawSnapshotReader open(Path logDir, OffsetAndEpoch snapshotId) throws IOException {
        FileRecords fileRecords = FileRecords.open(Snapshots.snapshotPath(logDir, snapshotId).toFile(), false, true, 0, false);
        return new FileRawSnapshotReader(fileRecords, snapshotId);
    }
}

