/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft.internals;

import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import org.apache.pinot.shaded.org.apache.kafka.raft.BatchReader;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.CloseListener;

public class MemoryBatchReader<T>
implements BatchReader<T> {
    private final CloseListener<BatchReader<T>> closeListener;
    private final Iterator<BatchReader.Batch<T>> iterator;
    private final long baseOffset;
    private final long lastOffset;

    public MemoryBatchReader(List<BatchReader.Batch<T>> batches, CloseListener<BatchReader<T>> closeListener) {
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("MemoryBatchReader requires at least one batch to iterate, but an empty list was provided");
        }
        this.closeListener = closeListener;
        this.iterator = batches.iterator();
        this.baseOffset = batches.get(0).baseOffset();
        this.lastOffset = batches.get(batches.size() - 1).lastOffset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public BatchReader.Batch<T> next() {
        return this.iterator.next();
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public OptionalLong lastOffset() {
        return OptionalLong.of(this.lastOffset);
    }

    @Override
    public void close() {
        this.closeListener.onClose(this);
    }
}

