/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Timer;
import org.apache.pinot.shaded.org.apache.kafka.raft.ElectionState;
import org.apache.pinot.shaded.org.apache.kafka.raft.EpochState;

public class ResignedState
implements EpochState {
    private final int localId;
    private final int epoch;
    private final Set<Integer> voters;
    private final long electionTimeoutMs;
    private final Set<Integer> unackedVoters;
    private final Timer electionTimer;
    private final List<Integer> preferredSuccessors;

    public ResignedState(Time time, int localId, int epoch, Set<Integer> voters, long electionTimeoutMs, List<Integer> preferredSuccessors) {
        this.localId = localId;
        this.epoch = epoch;
        this.voters = voters;
        this.unackedVoters = new HashSet<Integer>(voters);
        this.unackedVoters.remove(localId);
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer(electionTimeoutMs);
        this.preferredSuccessors = preferredSuccessors;
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localId, this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    public Set<Integer> unackedVoters() {
        return this.unackedVoters;
    }

    public void acknowledgeResignation(int voterId) {
        if (!this.voters.contains(voterId)) {
            throw new IllegalArgumentException("Attempt to acknowledge delivery of `EndQuorumEpoch` by a non-voter " + voterId);
        }
        this.unackedVoters.remove(voterId);
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public List<Integer> preferredSuccessors() {
        return this.preferredSuccessors;
    }

    @Override
    public String name() {
        return "Resigned";
    }

    public String toString() {
        return "ResignedState(localId=" + this.localId + ", epoch=" + this.epoch + ", voters=" + this.voters + ", electionTimeoutMs=" + this.electionTimeoutMs + ", unackedVoters=" + this.unackedVoters + ", preferredSuccessors=" + this.preferredSuccessors + ')';
    }

    @Override
    public void close() {
    }
}

