/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftMessage;

public abstract class RaftResponse
implements RaftMessage {
    protected final int correlationId;
    protected final ApiMessage data;

    protected RaftResponse(int correlationId, ApiMessage data) {
        this.correlationId = correlationId;
        this.data = data;
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public ApiMessage data() {
        return this.data;
    }

    public static class Outbound
    extends RaftResponse {
        public Outbound(int requestId, ApiMessage data) {
            super(requestId, data);
        }

        public String toString() {
            return "OutboundResponse(correlationId=" + this.correlationId + ", data=" + this.data + ')';
        }
    }

    public static class Inbound
    extends RaftResponse {
        private final int sourceId;

        public Inbound(int correlationId, ApiMessage data, int sourceId) {
            super(correlationId, data);
            this.sourceId = sourceId;
        }

        public int sourceId() {
            return this.sourceId;
        }

        public String toString() {
            return "InboundResponse(correlationId=" + this.correlationId + ", data=" + this.data + ", sourceId=" + this.sourceId + ')';
        }
    }
}

