/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.raft.ElectionState;
import org.apache.pinot.shaded.org.apache.kafka.raft.EpochState;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata;

public class LeaderState
implements EpochState {
    private final int localId;
    private final int epoch;
    private final long epochStartOffset;
    private Optional<LogOffsetMetadata> highWatermark;
    private final Map<Integer, VoterState> voterReplicaStates = new HashMap<Integer, VoterState>();
    private final Map<Integer, ReplicaState> observerReplicaStates = new HashMap<Integer, ReplicaState>();
    private final Set<Integer> grantingVoters = new HashSet<Integer>();
    private static final long OBSERVER_SESSION_TIMEOUT_MS = 300000L;

    protected LeaderState(int localId, int epoch, long epochStartOffset, Set<Integer> voters, Set<Integer> grantingVoters) {
        this.localId = localId;
        this.epoch = epoch;
        this.epochStartOffset = epochStartOffset;
        this.highWatermark = Optional.empty();
        for (int voterId : voters) {
            boolean hasAcknowledgedLeader = voterId == localId;
            this.voterReplicaStates.put(voterId, new VoterState(voterId, hasAcknowledgedLeader));
        }
        this.grantingVoters.addAll(grantingVoters);
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localId, this.voterReplicaStates.keySet());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    public Set<Integer> followers() {
        return this.voterReplicaStates.keySet().stream().filter(id -> id != this.localId).collect(Collectors.toSet());
    }

    public Set<Integer> grantingVoters() {
        return this.grantingVoters;
    }

    public int localId() {
        return this.localId;
    }

    public Set<Integer> nonAcknowledgingVoters() {
        HashSet<Integer> nonAcknowledging = new HashSet<Integer>();
        for (VoterState state : this.voterReplicaStates.values()) {
            if (state.hasAcknowledgedLeader) continue;
            nonAcknowledging.add(state.nodeId);
        }
        return nonAcknowledging;
    }

    private boolean updateHighWatermark() {
        List<VoterState> followersByDescendingFetchOffset = this.followersByDescendingFetchOffset();
        int indexOfHw = this.voterReplicaStates.size() / 2;
        Optional highWatermarkUpdateOpt = followersByDescendingFetchOffset.get((int)indexOfHw).endOffset;
        if (highWatermarkUpdateOpt.isPresent()) {
            LogOffsetMetadata highWatermarkUpdateMetadata = (LogOffsetMetadata)highWatermarkUpdateOpt.get();
            long highWatermarkUpdate = highWatermarkUpdateMetadata.offset;
            if (highWatermarkUpdate > this.epochStartOffset) {
                if (this.highWatermark.isPresent()) {
                    LogOffsetMetadata currentHighWatermarkMetadata = this.highWatermark.get();
                    if (highWatermarkUpdate > currentHighWatermarkMetadata.offset || highWatermarkUpdate == currentHighWatermarkMetadata.offset && !highWatermarkUpdateMetadata.metadata.equals(currentHighWatermarkMetadata.metadata)) {
                        this.highWatermark = highWatermarkUpdateOpt;
                        return true;
                    }
                    return false;
                }
                this.highWatermark = highWatermarkUpdateOpt;
                return true;
            }
        }
        return false;
    }

    public boolean updateLocalState(long fetchTimestamp, LogOffsetMetadata logOffsetMetadata) {
        return this.updateReplicaState(this.localId, fetchTimestamp, logOffsetMetadata);
    }

    public boolean updateReplicaState(int replicaId, long fetchTimestamp, LogOffsetMetadata logOffsetMetadata) {
        if (replicaId < 0) {
            return false;
        }
        ReplicaState state = this.getReplicaState(replicaId);
        state.updateFetchTimestamp(fetchTimestamp);
        return this.updateEndOffset(state, logOffsetMetadata);
    }

    public List<Integer> nonLeaderVotersByDescendingFetchOffset() {
        return this.followersByDescendingFetchOffset().stream().filter(state -> state.nodeId != this.localId).map(state -> state.nodeId).collect(Collectors.toList());
    }

    private List<VoterState> followersByDescendingFetchOffset() {
        return new ArrayList<VoterState>(this.voterReplicaStates.values()).stream().sorted().collect(Collectors.toList());
    }

    private boolean updateEndOffset(ReplicaState state, LogOffsetMetadata endOffsetMetadata) {
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset > endOffsetMetadata.offset) {
                throw new IllegalArgumentException("Non-monotonic update to end offset for nodeId " + state.nodeId);
            }
        });
        state.endOffset = Optional.of(endOffsetMetadata);
        if (this.isVoter(state.nodeId)) {
            ((VoterState)state).hasAcknowledgedLeader = true;
            this.addAcknowledgementFrom(state.nodeId);
            return this.updateHighWatermark();
        }
        return false;
    }

    public void addAcknowledgementFrom(int remoteNodeId) {
        VoterState voterState = this.ensureValidVoter(remoteNodeId);
        voterState.hasAcknowledgedLeader = true;
    }

    private VoterState ensureValidVoter(int remoteNodeId) {
        VoterState state = this.voterReplicaStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Unexpected acknowledgement from non-voter " + remoteNodeId);
        }
        return state;
    }

    public long epochStartOffset() {
        return this.epochStartOffset;
    }

    ReplicaState getReplicaState(int remoteNodeId) {
        ReplicaState state = this.voterReplicaStates.get(remoteNodeId);
        if (state == null) {
            this.observerReplicaStates.putIfAbsent(remoteNodeId, new ReplicaState(remoteNodeId));
            return this.observerReplicaStates.get(remoteNodeId);
        }
        return state;
    }

    Map<Integer, Long> getVoterEndOffsets() {
        return LeaderState.getReplicaEndOffsets(this.voterReplicaStates);
    }

    Map<Integer, Long> getObserverStates(long currentTimeMs) {
        this.clearInactiveObservers(currentTimeMs);
        return LeaderState.getReplicaEndOffsets(this.observerReplicaStates);
    }

    private static <R extends ReplicaState> Map<Integer, Long> getReplicaEndOffsets(Map<Integer, R> replicaStates) {
        return replicaStates.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReplicaState)e.getValue()).endOffset.map(logOffsetMetadata -> logOffsetMetadata.offset).orElse(-1L)));
    }

    private void clearInactiveObservers(long currentTimeMs) {
        this.observerReplicaStates.entrySet().removeIf(integerReplicaStateEntry -> currentTimeMs - ((ReplicaState)integerReplicaStateEntry.getValue()).lastFetchTimestamp.orElse(-1L) >= 300000L);
    }

    private boolean isVoter(int remoteNodeId) {
        return this.voterReplicaStates.containsKey(remoteNodeId);
    }

    public String toString() {
        return "Leader(localId=" + this.localId + ", epoch=" + this.epoch + ", epochStartOffset=" + this.epochStartOffset + ')';
    }

    @Override
    public String name() {
        return "Leader";
    }

    @Override
    public void close() {
    }

    private static class VoterState
    extends ReplicaState {
        boolean hasAcknowledgedLeader;

        public VoterState(int nodeId, boolean hasAcknowledgedLeader) {
            super(nodeId);
            this.hasAcknowledgedLeader = hasAcknowledgedLeader;
        }
    }

    private static class ReplicaState
    implements Comparable<ReplicaState> {
        final int nodeId;
        Optional<LogOffsetMetadata> endOffset;
        OptionalLong lastFetchTimestamp;

        public ReplicaState(int nodeId) {
            this.nodeId = nodeId;
            this.endOffset = Optional.empty();
            this.lastFetchTimestamp = OptionalLong.empty();
        }

        void updateFetchTimestamp(long currentFetchTimeMs) {
            this.lastFetchTimestamp = OptionalLong.of(Math.max(this.lastFetchTimestamp.orElse(-1L), currentFetchTimeMs));
        }

        @Override
        public int compareTo(ReplicaState that) {
            if (this.endOffset.equals(that.endOffset)) {
                return Integer.compare(this.nodeId, that.nodeId);
            }
            if (!this.endOffset.isPresent()) {
                return 1;
            }
            if (!that.endOffset.isPresent()) {
                return -1;
            }
            return Long.compare(that.endOffset.get().offset, this.endOffset.get().offset);
        }
    }
}

