/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaException;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.pinot.shaded.org.apache.kafka.common.memory.MemoryPool;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.FetchRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.FetchResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.message.VoteRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.VoteResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.pinot.shaded.org.apache.kafka.common.record.CompressionType;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.Records;
import org.apache.pinot.shaded.org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.UnalignedRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.VoteRequest;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.VoteResponse;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Timer;
import org.apache.pinot.shaded.org.apache.kafka.raft.BatchReader;
import org.apache.pinot.shaded.org.apache.kafka.raft.CandidateState;
import org.apache.pinot.shaded.org.apache.kafka.raft.ExpirationService;
import org.apache.pinot.shaded.org.apache.kafka.raft.FollowerState;
import org.apache.pinot.shaded.org.apache.kafka.raft.Isolation;
import org.apache.pinot.shaded.org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.LeaderState;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogAppendInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogFetchInfo;
import org.apache.pinot.shaded.org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.pinot.shaded.org.apache.kafka.raft.NetworkChannel;
import org.apache.pinot.shaded.org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.QuorumState;
import org.apache.pinot.shaded.org.apache.kafka.raft.QuorumStateStore;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftClient;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftConfig;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftMessage;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftMessageQueue;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftRequest;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftResponse;
import org.apache.pinot.shaded.org.apache.kafka.raft.RaftUtil;
import org.apache.pinot.shaded.org.apache.kafka.raft.RecordSerde;
import org.apache.pinot.shaded.org.apache.kafka.raft.ReplicatedLog;
import org.apache.pinot.shaded.org.apache.kafka.raft.RequestManager;
import org.apache.pinot.shaded.org.apache.kafka.raft.ResignedState;
import org.apache.pinot.shaded.org.apache.kafka.raft.UnattachedState;
import org.apache.pinot.shaded.org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.pinot.shaded.org.apache.kafka.raft.VotedState;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.BatchMemoryPool;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.BlockingMessageQueue;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.CloseListener;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.FuturePurgatory;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.MemoryBatchReader;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.RecordsBatchReader;
import org.apache.pinot.shaded.org.apache.kafka.raft.internals.ThresholdPurgatory;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.pinot.shaded.org.apache.kafka.snapshot.SnapshotWriter;
import org.slf4j.Logger;

public class KafkaRaftClient<T>
implements RaftClient<T> {
    private static final int RETRY_BACKOFF_BASE_MS = 100;
    public static final int MAX_FETCH_WAIT_MS = 500;
    public static final int MAX_BATCH_SIZE_BYTES = 0x800000;
    public static final int MAX_FETCH_SIZE_BYTES = 0x800000;
    private final AtomicReference<GracefulShutdown> shutdown = new AtomicReference();
    private final Logger logger;
    private final Time time;
    private final int fetchMaxWaitMs;
    private final String clusterId;
    private final NetworkChannel channel;
    private final ReplicatedLog log;
    private final Random random;
    private final FuturePurgatory<Long> appendPurgatory;
    private final FuturePurgatory<Long> fetchPurgatory;
    private final RecordSerde<T> serde;
    private final MemoryPool memoryPool;
    private final RaftMessageQueue messageQueue;
    private final RaftConfig raftConfig;
    private final KafkaRaftMetrics kafkaRaftMetrics;
    private final QuorumState quorum;
    private final RequestManager requestManager;
    private final List<ListenerContext> listenerContexts = new ArrayList<ListenerContext>();
    private final ConcurrentLinkedQueue<RaftClient.Listener<T>> pendingListeners = new ConcurrentLinkedQueue();
    private volatile BatchAccumulator<T> accumulator;

    public KafkaRaftClient(RecordSerde<T> serde, NetworkChannel channel, ReplicatedLog log, QuorumStateStore quorumStateStore, Time time, Metrics metrics, ExpirationService expirationService, LogContext logContext, String clusterId, OptionalInt nodeId, RaftConfig raftConfig) {
        this(serde, channel, new BlockingMessageQueue(), log, quorumStateStore, new BatchMemoryPool(5, 0x800000), time, metrics, expirationService, 500, clusterId, nodeId, logContext, new Random(), raftConfig);
    }

    KafkaRaftClient(RecordSerde<T> serde, NetworkChannel channel, RaftMessageQueue messageQueue, ReplicatedLog log, QuorumStateStore quorumStateStore, MemoryPool memoryPool, Time time, Metrics metrics, ExpirationService expirationService, int fetchMaxWaitMs, String clusterId, OptionalInt nodeId, LogContext logContext, Random random, RaftConfig raftConfig) {
        this.serde = serde;
        this.channel = channel;
        this.messageQueue = messageQueue;
        this.log = log;
        this.memoryPool = memoryPool;
        this.fetchPurgatory = new ThresholdPurgatory<Long>(expirationService);
        this.appendPurgatory = new ThresholdPurgatory<Long>(expirationService);
        this.time = time;
        this.clusterId = clusterId;
        this.fetchMaxWaitMs = fetchMaxWaitMs;
        this.logger = logContext.logger(KafkaRaftClient.class);
        this.random = random;
        this.raftConfig = raftConfig;
        Set<Integer> quorumVoterIds = raftConfig.quorumVoterIds();
        this.requestManager = new RequestManager(quorumVoterIds, raftConfig.retryBackoffMs(), raftConfig.requestTimeoutMs(), random);
        this.quorum = new QuorumState(nodeId, quorumVoterIds, raftConfig.electionTimeoutMs(), raftConfig.fetchTimeoutMs(), quorumStateStore, time, logContext, random);
        this.kafkaRaftMetrics = new KafkaRaftMetrics(metrics, "raft", this.quorum);
        this.kafkaRaftMetrics.updateNumUnknownVoterConnections(this.quorum.remoteVoters().size());
        Map<Integer, RaftConfig.AddressSpec> voterAddresses = raftConfig.quorumVoterConnections();
        voterAddresses.entrySet().stream().filter(e -> e.getValue() instanceof RaftConfig.InetAddressSpec).forEach(e -> this.channel.updateEndpoint((Integer)e.getKey(), (RaftConfig.InetAddressSpec)e.getValue()));
    }

    private void updateFollowerHighWatermark(FollowerState state, OptionalLong highWatermarkOpt) {
        highWatermarkOpt.ifPresent(highWatermark -> {
            long newHighWatermark = Math.min(this.endOffset().offset, highWatermark);
            if (state.updateHighWatermark(OptionalLong.of(newHighWatermark))) {
                this.logger.debug("Follower high watermark updated to {}", (Object)newHighWatermark);
                this.log.updateHighWatermark(new LogOffsetMetadata(newHighWatermark));
                this.updateListenersProgress(newHighWatermark);
            }
        });
    }

    private void updateLeaderEndOffsetAndTimestamp(LeaderState state, long currentTimeMs) {
        LogOffsetMetadata endOffsetMetadata = this.log.endOffset();
        if (state.updateLocalState(currentTimeMs, endOffsetMetadata)) {
            this.onUpdateLeaderHighWatermark(state, currentTimeMs);
        }
        this.fetchPurgatory.maybeComplete(endOffsetMetadata.offset, currentTimeMs);
    }

    private void onUpdateLeaderHighWatermark(LeaderState state, long currentTimeMs) {
        state.highWatermark().ifPresent(highWatermark -> {
            this.logger.debug("Leader high watermark updated to {}", highWatermark);
            this.log.updateHighWatermark((LogOffsetMetadata)highWatermark);
            this.appendPurgatory.maybeComplete(highWatermark.offset, currentTimeMs);
            this.updateListenersProgress(highWatermark.offset);
        });
    }

    private void updateListenersProgress(long highWatermark) {
        this.updateListenersProgress(this.listenerContexts, highWatermark);
    }

    private void updateListenersProgress(List<ListenerContext> listenerContexts, long highWatermark) {
        for (ListenerContext listenerContext : listenerContexts) {
            listenerContext.nextExpectedOffset().ifPresent(nextExpectedOffset -> {
                if (nextExpectedOffset < this.log.startOffset()) {
                    listenerContext.fireHandleSnapshot(this.log.startOffset());
                }
            });
            listenerContext.nextExpectedOffset().ifPresent(nextExpectedOffset -> {
                if (nextExpectedOffset < highWatermark) {
                    LogFetchInfo readInfo = this.log.read(nextExpectedOffset, Isolation.COMMITTED);
                    listenerContext.fireHandleCommit(nextExpectedOffset, readInfo.records);
                }
            });
        }
    }

    private void maybeFireHandleCommit(long baseOffset, int epoch, List<T> records) {
        for (ListenerContext listenerContext : this.listenerContexts) {
            long nextExpectedOffset;
            OptionalLong nextExpectedOffsetOpt = listenerContext.nextExpectedOffset();
            if (!nextExpectedOffsetOpt.isPresent() || (nextExpectedOffset = nextExpectedOffsetOpt.getAsLong()) != baseOffset) continue;
            listenerContext.fireHandleCommit(baseOffset, epoch, records);
        }
    }

    private void maybeFireHandleClaim(LeaderState state) {
        int leaderEpoch = state.epoch();
        long epochStartOffset = state.epochStartOffset();
        for (ListenerContext listenerContext : this.listenerContexts) {
            listenerContext.maybeFireHandleClaim(leaderEpoch, epochStartOffset);
        }
    }

    private void fireHandleResign(int epoch) {
        for (ListenerContext listenerContext : this.listenerContexts) {
            listenerContext.fireHandleResign(epoch);
        }
    }

    @Override
    public void initialize() throws IOException {
        this.quorum.initialize(new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch()));
        long currentTimeMs = this.time.milliseconds();
        if (this.quorum.isLeader()) {
            throw new IllegalStateException("Voter cannot initialize as a Leader");
        }
        if (this.quorum.isCandidate()) {
            this.onBecomeCandidate(currentTimeMs);
        } else if (this.quorum.isFollower()) {
            this.onBecomeFollower(currentTimeMs);
        }
        if (this.quorum.isVoter() && this.quorum.remoteVoters().isEmpty() && !this.quorum.isLeader() && !this.quorum.isCandidate()) {
            this.transitionToCandidate(currentTimeMs);
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.pendingListeners.add(listener);
        this.wakeup();
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.quorum.leaderAndEpoch();
    }

    private OffsetAndEpoch endOffset() {
        return new OffsetAndEpoch(this.log.endOffset().offset, this.log.lastFetchedEpoch());
    }

    private void resetConnections() {
        this.requestManager.resetAll();
    }

    private void onBecomeLeader(long currentTimeMs) {
        LeaderState state = this.quorum.leaderStateOrThrow();
        this.log.initializeLeaderEpoch(this.quorum.epoch());
        this.appendLeaderChangeMessage(state, this.log.endOffset().offset, currentTimeMs);
        this.updateLeaderEndOffsetAndTimestamp(state, currentTimeMs);
        this.resetConnections();
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
        this.accumulator = new BatchAccumulator<T>(this.quorum.epoch(), this.log.endOffset().offset, this.raftConfig.appendLingerMs(), 0x800000, this.memoryPool, this.time, CompressionType.NONE, this.serde);
    }

    private static List<LeaderChangeMessage.Voter> convertToVoters(Set<Integer> voterIds) {
        return voterIds.stream().map(follower -> new LeaderChangeMessage.Voter().setVoterId((int)follower)).collect(Collectors.toList());
    }

    private void appendLeaderChangeMessage(LeaderState state, long baseOffset, long currentTimeMs) {
        List<LeaderChangeMessage.Voter> voters = KafkaRaftClient.convertToVoters(state.followers());
        List<LeaderChangeMessage.Voter> grantingVoters = KafkaRaftClient.convertToVoters(state.grantingVoters());
        voters.add(new LeaderChangeMessage.Voter().setVoterId(state.election().leaderId()));
        LeaderChangeMessage leaderChangeMessage = new LeaderChangeMessage().setLeaderId(state.election().leaderId()).setVoters(voters).setGrantingVoters(grantingVoters);
        MemoryRecords records = MemoryRecords.withLeaderChangeMessage(baseOffset, currentTimeMs, this.quorum.epoch(), leaderChangeMessage);
        this.appendAsLeader(records);
        this.flushLeaderLog(state, currentTimeMs);
    }

    private void flushLeaderLog(LeaderState state, long currentTimeMs) {
        this.updateLeaderEndOffsetAndTimestamp(state, currentTimeMs);
        this.log.flush();
    }

    private boolean maybeTransitionToLeader(CandidateState state, long currentTimeMs) throws IOException {
        if (state.isVoteGranted()) {
            long endOffset = this.log.endOffset().offset;
            this.quorum.transitionToLeader(endOffset);
            this.onBecomeLeader(currentTimeMs);
            return true;
        }
        return false;
    }

    private void onBecomeCandidate(long currentTimeMs) throws IOException {
        CandidateState state = this.quorum.candidateStateOrThrow();
        if (!this.maybeTransitionToLeader(state, currentTimeMs)) {
            this.resetConnections();
            this.kafkaRaftMetrics.updateElectionStartMs(currentTimeMs);
        }
    }

    private void maybeResignLeadership() {
        if (this.quorum.isLeader()) {
            this.fireHandleResign(this.quorum.epoch());
        }
        if (this.accumulator != null) {
            this.accumulator.close();
            this.accumulator = null;
        }
    }

    private void transitionToCandidate(long currentTimeMs) throws IOException {
        this.maybeResignLeadership();
        this.quorum.transitionToCandidate();
        this.onBecomeCandidate(currentTimeMs);
    }

    private void transitionToUnattached(int epoch) throws IOException {
        this.maybeResignLeadership();
        this.quorum.transitionToUnattached(epoch);
        this.resetConnections();
    }

    private void transitionToResigned(List<Integer> preferredSuccessors) {
        this.fetchPurgatory.completeAllExceptionally(Errors.BROKER_NOT_AVAILABLE.exception("The broker is shutting down"));
        this.quorum.transitionToResigned(preferredSuccessors);
        this.resetConnections();
    }

    private void transitionToVoted(int candidateId, int epoch) throws IOException {
        this.maybeResignLeadership();
        this.quorum.transitionToVoted(epoch, candidateId);
        this.resetConnections();
    }

    private void onBecomeFollower(long currentTimeMs) {
        this.kafkaRaftMetrics.maybeUpdateElectionLatency(currentTimeMs);
        this.resetConnections();
        this.fetchPurgatory.completeAllExceptionally(new NotLeaderOrFollowerException("Cannot process the fetch request because the node is no longer the leader."));
        this.appendPurgatory.completeAllExceptionally(new NotLeaderOrFollowerException("Failed to receive sufficient acknowledgments for this append before leader change."));
    }

    private void transitionToFollower(int epoch, int leaderId, long currentTimeMs) throws IOException {
        this.maybeResignLeadership();
        this.quorum.transitionToFollower(epoch, leaderId);
        this.onBecomeFollower(currentTimeMs);
    }

    private VoteResponseData buildVoteResponse(Errors partitionLevelError, boolean voteGranted) {
        return VoteResponse.singletonResponse(Errors.NONE, this.log.topicPartition(), partitionLevelError, this.quorum.epoch(), this.quorum.leaderIdOrSentinel(), voteGranted);
    }

    private VoteResponseData handleVoteRequest(RaftRequest.Inbound requestMetadata) throws IOException {
        boolean voteGranted;
        VoteRequestData request = (VoteRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new VoteResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        VoteRequestData.PartitionData partitionRequest = request.topics().get(0).partitions().get(0);
        int candidateId = partitionRequest.candidateId();
        int candidateEpoch = partitionRequest.candidateEpoch();
        int lastEpoch = partitionRequest.lastOffsetEpoch();
        long lastEpochEndOffset = partitionRequest.lastOffset();
        if (lastEpochEndOffset < 0L || lastEpoch < 0 || lastEpoch >= candidateEpoch) {
            return this.buildVoteResponse(Errors.INVALID_REQUEST, false);
        }
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(candidateId, candidateEpoch);
        if (errorOpt.isPresent()) {
            return this.buildVoteResponse(errorOpt.get(), false);
        }
        if (candidateEpoch > this.quorum.epoch()) {
            this.transitionToUnattached(candidateEpoch);
        }
        if (this.quorum.isLeader()) {
            this.logger.debug("Rejecting vote request {} with epoch {} since we are already leader on that epoch", (Object)request, (Object)candidateEpoch);
            voteGranted = false;
        } else if (this.quorum.isCandidate()) {
            this.logger.debug("Rejecting vote request {} with epoch {} since we are already candidate on that epoch", (Object)request, (Object)candidateEpoch);
            voteGranted = false;
        } else if (this.quorum.isResigned()) {
            this.logger.debug("Rejecting vote request {} with epoch {} since we have resigned as candidate/leader in this epoch", (Object)request, (Object)candidateEpoch);
            voteGranted = false;
        } else if (this.quorum.isFollower()) {
            FollowerState state = this.quorum.followerStateOrThrow();
            this.logger.debug("Rejecting vote request {} with epoch {} since we already have a leader {} on that epoch", request, candidateEpoch, state.leaderId());
            voteGranted = false;
        } else if (this.quorum.isVoted()) {
            VotedState state = this.quorum.votedStateOrThrow();
            boolean bl = voteGranted = state.votedId() == candidateId;
            if (!voteGranted) {
                this.logger.debug("Rejecting vote request {} with epoch {} since we already have voted for another candidate {} on that epoch", request, candidateEpoch, state.votedId());
            }
        } else if (this.quorum.isUnattached()) {
            OffsetAndEpoch lastEpochEndOffsetAndEpoch = new OffsetAndEpoch(lastEpochEndOffset, lastEpoch);
            boolean bl = voteGranted = lastEpochEndOffsetAndEpoch.compareTo(this.endOffset()) >= 0;
            if (voteGranted) {
                this.transitionToVoted(candidateId, candidateEpoch);
            }
        } else {
            throw new IllegalStateException("Unexpected quorum state " + this.quorum);
        }
        this.logger.info("Vote request {} is {}", (Object)request, (Object)(voteGranted ? "granted" : "rejected"));
        return this.buildVoteResponse(Errors.NONE, voteGranted);
    }

    private boolean handleVoteResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.sourceId();
        VoteResponseData response = (VoteResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode(response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        VoteResponseData.PartitionData partitionResponse = response.topics().get(0).partitions().get(0);
        Errors error = Errors.forCode(partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (error == Errors.NONE) {
            if (this.quorum.isLeader()) {
                this.logger.debug("Ignoring vote response {} since we already became leader for epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            } else if (this.quorum.isCandidate()) {
                CandidateState state = this.quorum.candidateStateOrThrow();
                if (partitionResponse.voteGranted()) {
                    state.recordGrantedVote(remoteNodeId);
                    this.maybeTransitionToLeader(state, currentTimeMs);
                } else {
                    state.recordRejectedVote(remoteNodeId);
                    if (state.isVoteRejected() && !state.isBackingOff()) {
                        this.logger.info("Insufficient remaining votes to become leader (rejected by {}). We will backoff before retrying election again", (Object)state.rejectingVoters());
                        state.startBackingOff(currentTimeMs, this.binaryExponentialElectionBackoffMs(state.retries()));
                    }
                }
            } else {
                this.logger.debug("Ignoring vote response {} since we are no longer a candidate in epoch {}", (Object)partitionResponse, (Object)this.quorum.epoch());
            }
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private int binaryExponentialElectionBackoffMs(int retries) {
        if (retries <= 0) {
            throw new IllegalArgumentException("Retries " + retries + " should be larger than zero");
        }
        return Math.min(100 * this.random.nextInt(2 << Math.min(20, retries - 1)), this.raftConfig.electionBackoffMaxMs());
    }

    private int strictExponentialElectionBackoffMs(int positionInSuccessors, int totalNumSuccessors) {
        if (positionInSuccessors <= 0 || positionInSuccessors >= totalNumSuccessors) {
            throw new IllegalArgumentException("Position " + positionInSuccessors + " should be larger than zero and smaller than total number of successors " + totalNumSuccessors);
        }
        int retryBackOffBaseMs = this.raftConfig.electionBackoffMaxMs() >> totalNumSuccessors - 1;
        return Math.min(this.raftConfig.electionBackoffMaxMs(), retryBackOffBaseMs << positionInSuccessors - 1);
    }

    private BeginQuorumEpochResponseData buildBeginQuorumEpochResponse(Errors partitionLevelError) {
        return BeginQuorumEpochResponse.singletonResponse(Errors.NONE, this.log.topicPartition(), partitionLevelError, this.quorum.epoch(), this.quorum.leaderIdOrSentinel());
    }

    private BeginQuorumEpochResponseData handleBeginQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) throws IOException {
        int requestEpoch;
        BeginQuorumEpochRequestData request = (BeginQuorumEpochRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new BeginQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        BeginQuorumEpochRequestData.PartitionData partitionRequest = request.topics().get(0).partitions().get(0);
        int requestLeaderId = partitionRequest.leaderId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestLeaderId, requestEpoch = partitionRequest.leaderEpoch());
        if (errorOpt.isPresent()) {
            return this.buildBeginQuorumEpochResponse(errorOpt.get());
        }
        this.maybeTransition(OptionalInt.of(requestLeaderId), requestEpoch, currentTimeMs);
        return this.buildBeginQuorumEpochResponse(Errors.NONE);
    }

    private boolean handleBeginQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        int remoteNodeId = responseMetadata.sourceId();
        BeginQuorumEpochResponseData response = (BeginQuorumEpochResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode(response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        BeginQuorumEpochResponseData.PartitionData partitionResponse = response.topics().get(0).partitions().get(0);
        Errors partitionError = Errors.forCode(partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            if (this.quorum.isLeader()) {
                LeaderState state = this.quorum.leaderStateOrThrow();
                state.addAcknowledgementFrom(remoteNodeId);
            } else {
                this.logger.debug("Ignoring BeginQuorumEpoch response {} since this node is not the leader anymore", (Object)response);
            }
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private EndQuorumEpochResponseData buildEndQuorumEpochResponse(Errors partitionLevelError) {
        return EndQuorumEpochResponse.singletonResponse(Errors.NONE, this.log.topicPartition(), partitionLevelError, this.quorum.epoch(), this.quorum.leaderIdOrSentinel());
    }

    private EndQuorumEpochResponseData handleEndQuorumEpochRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) throws IOException {
        FollowerState state;
        EndQuorumEpochRequestData request = (EndQuorumEpochRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return new EndQuorumEpochResponseData().setErrorCode(Errors.INVALID_REQUEST.code());
        }
        EndQuorumEpochRequestData.PartitionData partitionRequest = request.topics().get(0).partitions().get(0);
        int requestEpoch = partitionRequest.leaderEpoch();
        int requestLeaderId = partitionRequest.leaderId();
        Optional<Errors> errorOpt = this.validateVoterOnlyRequest(requestLeaderId, requestEpoch);
        if (errorOpt.isPresent()) {
            return this.buildEndQuorumEpochResponse(errorOpt.get());
        }
        this.maybeTransition(OptionalInt.of(requestLeaderId), requestEpoch, currentTimeMs);
        if (this.quorum.isFollower() && (state = this.quorum.followerStateOrThrow()).leaderId() == requestLeaderId) {
            List<Integer> preferredSuccessors = partitionRequest.preferredSuccessors();
            long electionBackoffMs = this.endEpochElectionBackoff(preferredSuccessors);
            this.logger.debug("Overriding follower fetch timeout to {} after receiving EndQuorumEpoch request from leader {} in epoch {}", electionBackoffMs, requestLeaderId, requestEpoch);
            state.overrideFetchTimeout(currentTimeMs, electionBackoffMs);
        }
        return this.buildEndQuorumEpochResponse(Errors.NONE);
    }

    private long endEpochElectionBackoff(List<Integer> preferredSuccessors) {
        int position = preferredSuccessors.indexOf(this.quorum.localIdOrThrow());
        if (position <= 0) {
            return 0L;
        }
        return this.strictExponentialElectionBackoffMs(position, preferredSuccessors.size());
    }

    private boolean handleEndQuorumEpochResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        int responseEpoch;
        OptionalInt responseLeaderId;
        EndQuorumEpochResponseData response = (EndQuorumEpochResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode(response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        EndQuorumEpochResponseData.PartitionData partitionResponse = response.topics().get(0).partitions().get(0);
        Errors partitionError = Errors.forCode(partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(partitionError, responseLeaderId = KafkaRaftClient.optionalLeaderId(partitionResponse.leaderId()), responseEpoch = partitionResponse.leaderEpoch(), currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        if (partitionError == Errors.NONE) {
            ResignedState resignedState = this.quorum.resignedStateOrThrow();
            resignedState.acknowledgeResignation(responseMetadata.sourceId());
            return true;
        }
        return this.handleUnexpectedError(partitionError, responseMetadata);
    }

    private FetchResponseData buildFetchResponse(Errors error, Records records, ValidOffsetAndEpoch validOffsetAndEpoch, Optional<LogOffsetMetadata> highWatermark) {
        return RaftUtil.singletonFetchResponse(this.log.topicPartition(), Errors.NONE, partitionData -> {
            partitionData.setRecordSet(records).setErrorCode(error.code()).setLogStartOffset(this.log.startOffset()).setHighWatermark(highWatermark.map(offsetMetadata -> offsetMetadata.offset).orElse(-1L));
            partitionData.currentLeader().setLeaderEpoch(this.quorum.epoch()).setLeaderId(this.quorum.leaderIdOrSentinel());
            switch (validOffsetAndEpoch.type()) {
                case DIVERGING: {
                    partitionData.divergingEpoch().setEpoch(validOffsetAndEpoch.offsetAndEpoch().epoch).setEndOffset(validOffsetAndEpoch.offsetAndEpoch().offset);
                    break;
                }
                case SNAPSHOT: {
                    partitionData.snapshotId().setEpoch(validOffsetAndEpoch.offsetAndEpoch().epoch).setEndOffset(validOffsetAndEpoch.offsetAndEpoch().offset);
                    break;
                }
            }
        });
    }

    private FetchResponseData buildEmptyFetchResponse(Errors error, Optional<LogOffsetMetadata> highWatermark) {
        return this.buildFetchResponse(error, MemoryRecords.EMPTY, ValidOffsetAndEpoch.valid(), highWatermark);
    }

    private boolean hasValidClusterId(FetchRequestData request) {
        if (request.clusterId() == null) {
            return true;
        }
        return this.clusterId.equals(request.clusterId());
    }

    private CompletableFuture<FetchResponseData> handleFetchRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        FetchRequestData request = (FetchRequestData)requestMetadata.data;
        if (!this.hasValidClusterId(request)) {
            return CompletableFuture.completedFuture(new FetchResponseData().setErrorCode(Errors.INCONSISTENT_CLUSTER_ID.code()));
        }
        if (!RaftUtil.hasValidTopicPartition(request, this.log.topicPartition())) {
            return CompletableFuture.completedFuture(new FetchResponseData().setErrorCode(Errors.INVALID_REQUEST.code()));
        }
        FetchRequestData.FetchPartition fetchPartition = request.topics().get(0).partitions().get(0);
        if (request.maxWaitMs() < 0 || fetchPartition.fetchOffset() < 0L || fetchPartition.lastFetchedEpoch() < 0 || fetchPartition.lastFetchedEpoch() > fetchPartition.currentLeaderEpoch()) {
            return CompletableFuture.completedFuture(this.buildEmptyFetchResponse(Errors.INVALID_REQUEST, Optional.empty()));
        }
        FetchResponseData response = this.tryCompleteFetchRequest(request.replicaId(), fetchPartition, currentTimeMs);
        FetchResponseData.FetchablePartitionResponse partitionResponse = response.responses().get(0).partitionResponses().get(0);
        if (partitionResponse.errorCode() != Errors.NONE.code() || partitionResponse.recordSet().sizeInBytes() > 0 || request.maxWaitMs() == 0) {
            return CompletableFuture.completedFuture(response);
        }
        CompletableFuture<Long> future = this.fetchPurgatory.await(fetchPartition.fetchOffset(), request.maxWaitMs());
        return future.handle((T completionTimeMs, U exception) -> {
            Throwable cause;
            Errors error;
            if (exception != null && (error = Errors.forException(cause = exception instanceof ExecutionException ? exception.getCause() : exception)) != Errors.REQUEST_TIMED_OUT) {
                this.logger.debug("Failed to handle fetch from {} at {} due to {}", new Object[]{request.replicaId(), fetchPartition.fetchOffset(), error});
                return this.buildEmptyFetchResponse(error, Optional.empty());
            }
            this.logger.trace("Completing delayed fetch from {} starting at offset {} at {}", request.replicaId(), fetchPartition.fetchOffset(), completionTimeMs);
            return this.tryCompleteFetchRequest(request.replicaId(), fetchPartition, this.time.milliseconds());
        });
    }

    private FetchResponseData tryCompleteFetchRequest(int replicaId, FetchRequestData.FetchPartition request, long currentTimeMs) {
        try {
            Records records;
            Optional<Errors> errorOpt = this.validateLeaderOnlyRequest(request.currentLeaderEpoch());
            if (errorOpt.isPresent()) {
                return this.buildEmptyFetchResponse(errorOpt.get(), Optional.empty());
            }
            long fetchOffset = request.fetchOffset();
            int lastFetchedEpoch = request.lastFetchedEpoch();
            LeaderState state = this.quorum.leaderStateOrThrow();
            ValidOffsetAndEpoch validOffsetAndEpoch = this.log.validateOffsetAndEpoch(fetchOffset, lastFetchedEpoch);
            if (validOffsetAndEpoch.type() == ValidOffsetAndEpoch.Type.VALID) {
                LogFetchInfo info = this.log.read(fetchOffset, Isolation.UNCOMMITTED);
                if (state.updateReplicaState(replicaId, currentTimeMs, info.startOffsetMetadata)) {
                    this.onUpdateLeaderHighWatermark(state, currentTimeMs);
                }
                records = info.records;
            } else {
                records = MemoryRecords.EMPTY;
            }
            return this.buildFetchResponse(Errors.NONE, records, validOffsetAndEpoch, state.highWatermark());
        }
        catch (Exception e) {
            this.logger.error("Caught unexpected error in fetch completion of request {}", (Object)request, (Object)e);
            return this.buildEmptyFetchResponse(Errors.UNKNOWN_SERVER_ERROR, Optional.empty());
        }
    }

    private static OptionalInt optionalLeaderId(int leaderIdOrNil) {
        if (leaderIdOrNil < 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(leaderIdOrNil);
    }

    private boolean handleFetchResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        FetchResponseData response = (FetchResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode(response.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (!RaftUtil.hasValidTopicPartition(response, this.log.topicPartition())) {
            return false;
        }
        FetchResponseData.FetchablePartitionResponse partitionResponse = response.responses().get(0).partitionResponses().get(0);
        FetchResponseData.LeaderIdAndEpoch currentLeaderIdAndEpoch = partitionResponse.currentLeader();
        OptionalInt responseLeaderId = KafkaRaftClient.optionalLeaderId(currentLeaderIdAndEpoch.leaderId());
        int responseEpoch = currentLeaderIdAndEpoch.leaderEpoch();
        Errors error = Errors.forCode(partitionResponse.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId, responseEpoch, currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        FollowerState state = this.quorum.followerStateOrThrow();
        if (error == Errors.NONE) {
            FetchResponseData.EpochEndOffset divergingEpoch = partitionResponse.divergingEpoch();
            if (divergingEpoch.epoch() >= 0) {
                OffsetAndEpoch divergingOffsetAndEpoch = new OffsetAndEpoch(divergingEpoch.endOffset(), divergingEpoch.epoch());
                state.highWatermark().ifPresent(highWatermark -> {
                    if (divergingOffsetAndEpoch.offset < highWatermark.offset) {
                        throw new KafkaException("The leader requested truncation to offset " + divergingOffsetAndEpoch.offset + ", which is below the current high watermark " + highWatermark);
                    }
                });
                long truncationOffset = this.log.truncateToEndOffset(divergingOffsetAndEpoch);
                this.logger.info("Truncated to offset {} from Fetch response from leader {}", (Object)truncationOffset, (Object)this.quorum.leaderIdOrSentinel());
            } else if (partitionResponse.snapshotId().epoch() >= 0 || partitionResponse.snapshotId().endOffset() >= 0L) {
                if (partitionResponse.snapshotId().epoch() < 0) {
                    this.logger.error("The leader sent a snapshot id with a valid end offset {} but with an invalid epoch {}", (Object)partitionResponse.snapshotId().endOffset(), (Object)partitionResponse.snapshotId().epoch());
                    return false;
                }
                if (partitionResponse.snapshotId().endOffset() < 0L) {
                    this.logger.error("The leader sent a snapshot id with a valid epoch {} but with an invalid end offset {}", (Object)partitionResponse.snapshotId().epoch(), (Object)partitionResponse.snapshotId().endOffset());
                    return false;
                }
                OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionResponse.snapshotId().endOffset(), partitionResponse.snapshotId().epoch());
                state.setFetchingSnapshot(Optional.of(this.log.createSnapshot(snapshotId)));
            } else {
                Records records = (Records)partitionResponse.recordSet();
                if (records.sizeInBytes() > 0) {
                    this.appendAsFollower(records);
                }
                OptionalLong highWatermark2 = partitionResponse.highWatermark() < 0L ? OptionalLong.empty() : OptionalLong.of(partitionResponse.highWatermark());
                this.updateFollowerHighWatermark(state, highWatermark2);
            }
            state.resetFetchTimeout(currentTimeMs);
            return true;
        }
        return this.handleUnexpectedError(error, responseMetadata);
    }

    private void appendAsFollower(Records records) {
        LogAppendInfo info = this.log.appendAsFollower(records);
        this.log.flush();
        OffsetAndEpoch endOffset = this.endOffset();
        this.kafkaRaftMetrics.updateFetchedRecords(info.lastOffset - info.firstOffset + 1L);
        this.kafkaRaftMetrics.updateLogEnd(endOffset);
        this.logger.trace("Follower end offset updated to {} after append", (Object)endOffset);
    }

    private LogAppendInfo appendAsLeader(Records records) {
        LogAppendInfo info = this.log.appendAsLeader(records, this.quorum.epoch());
        OffsetAndEpoch endOffset = this.endOffset();
        this.kafkaRaftMetrics.updateAppendRecords(info.lastOffset - info.firstOffset + 1L);
        this.kafkaRaftMetrics.updateLogEnd(endOffset);
        this.logger.trace("Leader appended records at base offset {}, new end offset is {}", (Object)info.firstOffset, (Object)endOffset);
        return info;
    }

    private DescribeQuorumResponseData handleDescribeQuorumRequest(RaftRequest.Inbound requestMetadata, long currentTimeMs) {
        DescribeQuorumRequestData describeQuorumRequestData = (DescribeQuorumRequestData)requestMetadata.data;
        if (!RaftUtil.hasValidTopicPartition(describeQuorumRequestData, this.log.topicPartition())) {
            return DescribeQuorumRequest.getPartitionLevelErrorResponse(describeQuorumRequestData, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        }
        if (!this.quorum.isLeader()) {
            return DescribeQuorumRequest.getTopLevelErrorResponse(Errors.INVALID_REQUEST);
        }
        LeaderState leaderState = this.quorum.leaderStateOrThrow();
        return DescribeQuorumResponse.singletonResponse(this.log.topicPartition(), leaderState.localId(), leaderState.epoch(), leaderState.highWatermark().isPresent() ? leaderState.highWatermark().get().offset : -1L, this.convertToReplicaStates(leaderState.getVoterEndOffsets()), this.convertToReplicaStates(leaderState.getObserverStates(currentTimeMs)));
    }

    private FetchSnapshotResponseData handleFetchSnapshotRequest(RaftRequest.Inbound requestMetadata) throws IOException {
        FetchSnapshotRequestData data = (FetchSnapshotRequestData)requestMetadata.data;
        if (data.topics().size() != 1 && data.topics().get(0).partitions().size() != 1) {
            return FetchSnapshotResponse.withTopLevelError(Errors.INVALID_REQUEST);
        }
        Optional<FetchSnapshotRequestData.PartitionSnapshot> partitionSnapshotOpt = FetchSnapshotRequest.forTopicPartition(data, this.log.topicPartition());
        if (!partitionSnapshotOpt.isPresent()) {
            TopicPartition unknownTopicPartition = new TopicPartition(data.topics().get(0).name(), data.topics().get(0).partitions().get(0).partition());
            return FetchSnapshotResponse.singleton(unknownTopicPartition, responsePartitionSnapshot -> responsePartitionSnapshot.setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        }
        FetchSnapshotRequestData.PartitionSnapshot partitionSnapshot = partitionSnapshotOpt.get();
        Optional<Errors> leaderValidation = this.validateLeaderOnlyRequest(partitionSnapshot.currentLeaderEpoch());
        if (leaderValidation.isPresent()) {
            return FetchSnapshotResponse.singleton(this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(((Errors)((Object)((Object)leaderValidation.get()))).code()));
        }
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionSnapshot.snapshotId().endOffset(), partitionSnapshot.snapshotId().epoch());
        Optional<RawSnapshotReader> snapshotOpt = this.log.readSnapshot(snapshotId);
        if (!snapshotOpt.isPresent()) {
            return FetchSnapshotResponse.singleton(this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(Errors.SNAPSHOT_NOT_FOUND.code()));
        }
        try (RawSnapshotReader snapshot = snapshotOpt.get();){
            int maxSnapshotSize;
            if (partitionSnapshot.position() < 0L || partitionSnapshot.position() >= snapshot.sizeInBytes()) {
                FetchSnapshotResponseData fetchSnapshotResponseData = FetchSnapshotResponse.singleton(this.log.topicPartition(), responsePartitionSnapshot -> this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).setErrorCode(Errors.POSITION_OUT_OF_RANGE.code()));
                return fetchSnapshotResponseData;
            }
            try {
                maxSnapshotSize = Math.toIntExact(snapshot.sizeInBytes());
            }
            catch (ArithmeticException e) {
                maxSnapshotSize = Integer.MAX_VALUE;
            }
            if (partitionSnapshot.position() > Integer.MAX_VALUE) {
                throw new IllegalStateException(String.format("Trying to fetch a snapshot with position: %d lager than Int.MaxValue", partitionSnapshot.position()));
            }
            UnalignedRecords records = snapshot.read(partitionSnapshot.position(), Math.min(data.maxBytes(), maxSnapshotSize));
            long snapshotSize = snapshot.sizeInBytes();
            FetchSnapshotResponseData fetchSnapshotResponseData = FetchSnapshotResponse.singleton(this.log.topicPartition(), responsePartitionSnapshot -> {
                this.addQuorumLeader((FetchSnapshotResponseData.PartitionSnapshot)responsePartitionSnapshot).snapshotId().setEndOffset(snapshotId.offset).setEpoch(snapshotId.epoch);
                return responsePartitionSnapshot.setSize(snapshotSize).setPosition(partitionSnapshot.position()).setUnalignedRecords(records);
            });
            return fetchSnapshotResponseData;
        }
    }

    private boolean handleFetchSnapshotResponse(RaftResponse.Inbound responseMetadata, long currentTimeMs) throws IOException {
        FetchSnapshotResponseData data = (FetchSnapshotResponseData)responseMetadata.data;
        Errors topLevelError = Errors.forCode(data.errorCode());
        if (topLevelError != Errors.NONE) {
            return this.handleTopLevelError(topLevelError, responseMetadata);
        }
        if (data.topics().size() != 1 && data.topics().get(0).partitions().size() != 1) {
            return false;
        }
        Optional<FetchSnapshotResponseData.PartitionSnapshot> partitionSnapshotOpt = FetchSnapshotResponse.forTopicPartition(data, this.log.topicPartition());
        if (!partitionSnapshotOpt.isPresent()) {
            return false;
        }
        FetchSnapshotResponseData.PartitionSnapshot partitionSnapshot = partitionSnapshotOpt.get();
        FetchSnapshotResponseData.LeaderIdAndEpoch currentLeaderIdAndEpoch = partitionSnapshot.currentLeader();
        OptionalInt responseLeaderId = KafkaRaftClient.optionalLeaderId(currentLeaderIdAndEpoch.leaderId());
        int responseEpoch = currentLeaderIdAndEpoch.leaderEpoch();
        Errors error = Errors.forCode(partitionSnapshot.errorCode());
        Optional<Boolean> handled = this.maybeHandleCommonResponse(error, responseLeaderId, responseEpoch, currentTimeMs);
        if (handled.isPresent()) {
            return handled.get();
        }
        FollowerState state = this.quorum.followerStateOrThrow();
        if (Errors.forCode(partitionSnapshot.errorCode()) == Errors.SNAPSHOT_NOT_FOUND || partitionSnapshot.snapshotId().endOffset() < 0L || partitionSnapshot.snapshotId().epoch() < 0) {
            this.logger.trace("Leader doesn't know about snapshot id {}, returned error {} and snapshot id {}", state.fetchingSnapshot(), partitionSnapshot.errorCode(), partitionSnapshot.snapshotId());
            state.setFetchingSnapshot(Optional.empty());
            state.resetFetchTimeout(currentTimeMs);
            return true;
        }
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(partitionSnapshot.snapshotId().endOffset(), partitionSnapshot.snapshotId().epoch());
        if (!state.fetchingSnapshot().isPresent()) {
            throw new IllegalStateException(String.format("Received unexpected fetch snapshot response: %s", partitionSnapshot));
        }
        RawSnapshotWriter snapshot = state.fetchingSnapshot().get();
        if (!snapshot.snapshotId().equals(snapshotId)) {
            throw new IllegalStateException(String.format("Received fetch snapshot response with an invalid id. Expected %s; Received %s", snapshot.snapshotId(), snapshotId));
        }
        if (snapshot.sizeInBytes() != partitionSnapshot.position()) {
            throw new IllegalStateException(String.format("Received fetch snapshot response with an invalid position. Expected %s; Received %s", snapshot.sizeInBytes(), partitionSnapshot.position()));
        }
        if (!(partitionSnapshot.unalignedRecords() instanceof MemoryRecords)) {
            throw new IllegalStateException(String.format("Received unexpected fetch snapshot response: %s", partitionSnapshot));
        }
        snapshot.append(new UnalignedMemoryRecords(((MemoryRecords)partitionSnapshot.unalignedRecords()).buffer()));
        if (snapshot.sizeInBytes() == partitionSnapshot.size()) {
            snapshot.freeze();
            state.setFetchingSnapshot(Optional.empty());
            if (this.log.truncateToLatestSnapshot()) {
                this.updateFollowerHighWatermark(state, OptionalLong.of(this.log.highWatermark().offset));
            } else {
                throw new IllegalStateException(String.format("Full log trunctation expected but didn't happen. Snapshot of %s, log end offset %s, last fetched %s", snapshot.snapshotId(), this.log.endOffset(), this.log.lastFetchedEpoch()));
            }
        }
        state.resetFetchTimeout(currentTimeMs);
        return true;
    }

    List<DescribeQuorumResponseData.ReplicaState> convertToReplicaStates(Map<Integer, Long> replicaEndOffsets) {
        return replicaEndOffsets.entrySet().stream().map(entry -> new DescribeQuorumResponseData.ReplicaState().setReplicaId((Integer)entry.getKey()).setLogEndOffset((Long)entry.getValue())).collect(Collectors.toList());
    }

    private boolean hasConsistentLeader(int epoch, OptionalInt leaderId) {
        if (leaderId.isPresent() && leaderId.getAsInt() == this.quorum.localIdOrSentinel()) {
            return this.quorum.isLeader();
        }
        return epoch != this.quorum.epoch() || !leaderId.isPresent() || !this.quorum.leaderId().isPresent() || leaderId.equals(this.quorum.leaderId());
    }

    private Optional<Boolean> maybeHandleCommonResponse(Errors error, OptionalInt leaderId, int epoch, long currentTimeMs) throws IOException {
        if (epoch < this.quorum.epoch() || error == Errors.UNKNOWN_LEADER_EPOCH) {
            return Optional.of(true);
        }
        if (epoch > this.quorum.epoch() || error == Errors.FENCED_LEADER_EPOCH || error == Errors.NOT_LEADER_OR_FOLLOWER) {
            this.maybeTransition(leaderId, epoch, currentTimeMs);
            return Optional.of(true);
        }
        if (epoch == this.quorum.epoch() && leaderId.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
            if (error == Errors.NONE) {
                return Optional.empty();
            }
            return Optional.of(true);
        }
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return Optional.of(false);
        }
        if (error == Errors.INCONSISTENT_GROUP_PROTOCOL) {
            throw new IllegalStateException("Received error indicating inconsistent voter sets");
        }
        if (error == Errors.INVALID_REQUEST) {
            throw new IllegalStateException("Received unexpected invalid request error");
        }
        return Optional.empty();
    }

    private void maybeTransition(OptionalInt leaderId, int epoch, long currentTimeMs) throws IOException {
        if (!this.hasConsistentLeader(epoch, leaderId)) {
            throw new IllegalStateException("Received request or response with leader " + leaderId + " and epoch " + epoch + " which is inconsistent with current leader " + this.quorum.leaderId() + " and epoch " + this.quorum.epoch());
        }
        if (epoch > this.quorum.epoch()) {
            if (leaderId.isPresent()) {
                this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
            } else {
                this.transitionToUnattached(epoch);
            }
        } else if (leaderId.isPresent() && !this.quorum.hasLeader()) {
            this.transitionToFollower(epoch, leaderId.getAsInt(), currentTimeMs);
        }
    }

    private boolean handleTopLevelError(Errors error, RaftResponse.Inbound response) {
        if (error == Errors.BROKER_NOT_AVAILABLE) {
            return false;
        }
        if (error == Errors.CLUSTER_AUTHORIZATION_FAILED) {
            throw new ClusterAuthorizationException("Received cluster authorization error in response " + response);
        }
        return this.handleUnexpectedError(error, response);
    }

    private boolean handleUnexpectedError(Errors error, RaftResponse.Inbound response) {
        this.logger.error("Unexpected error {} in {} response: {}", new Object[]{error, ApiKeys.forId(response.data.apiKey()), response});
        return false;
    }

    private void handleResponse(RaftResponse.Inbound response, long currentTimeMs) throws IOException {
        boolean handledSuccessfully;
        ApiKeys apiKey = ApiKeys.forId(response.data.apiKey());
        switch (apiKey) {
            case FETCH: {
                handledSuccessfully = this.handleFetchResponse(response, currentTimeMs);
                break;
            }
            case VOTE: {
                handledSuccessfully = this.handleVoteResponse(response, currentTimeMs);
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                handledSuccessfully = this.handleBeginQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            case END_QUORUM_EPOCH: {
                handledSuccessfully = this.handleEndQuorumEpochResponse(response, currentTimeMs);
                break;
            }
            case FETCH_SNAPSHOT: {
                handledSuccessfully = this.handleFetchSnapshotResponse(response, currentTimeMs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Received unexpected response type: " + (Object)((Object)apiKey));
            }
        }
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(response.sourceId());
        if (handledSuccessfully) {
            connection.onResponseReceived(response.correlationId);
        } else {
            connection.onResponseError(response.correlationId, currentTimeMs);
        }
    }

    private Optional<Errors> validateVoterOnlyRequest(int remoteNodeId, int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (remoteNodeId < 0) {
            return Optional.of(Errors.INVALID_REQUEST);
        }
        if (this.quorum.isObserver() || !this.quorum.isVoter(remoteNodeId)) {
            return Optional.of(Errors.INCONSISTENT_VOTER_SET);
        }
        return Optional.empty();
    }

    private Optional<Errors> validateLeaderOnlyRequest(int requestEpoch) {
        if (requestEpoch < this.quorum.epoch()) {
            return Optional.of(Errors.FENCED_LEADER_EPOCH);
        }
        if (requestEpoch > this.quorum.epoch()) {
            return Optional.of(Errors.UNKNOWN_LEADER_EPOCH);
        }
        if (!this.quorum.isLeader()) {
            return Optional.of(Errors.NOT_LEADER_OR_FOLLOWER);
        }
        if (this.shutdown.get() != null) {
            return Optional.of(Errors.BROKER_NOT_AVAILABLE);
        }
        return Optional.empty();
    }

    private void handleRequest(RaftRequest.Inbound request, long currentTimeMs) throws IOException {
        CompletableFuture<ApiMessage> responseFuture;
        ApiKeys apiKey = ApiKeys.forId(request.data.apiKey());
        switch (apiKey) {
            case FETCH: {
                responseFuture = this.handleFetchRequest(request, currentTimeMs);
                break;
            }
            case VOTE: {
                responseFuture = CompletableFuture.completedFuture(this.handleVoteRequest(request));
                break;
            }
            case BEGIN_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleBeginQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case END_QUORUM_EPOCH: {
                responseFuture = CompletableFuture.completedFuture(this.handleEndQuorumEpochRequest(request, currentTimeMs));
                break;
            }
            case DESCRIBE_QUORUM: {
                responseFuture = CompletableFuture.completedFuture(this.handleDescribeQuorumRequest(request, currentTimeMs));
                break;
            }
            case FETCH_SNAPSHOT: {
                responseFuture = CompletableFuture.completedFuture(this.handleFetchSnapshotRequest(request));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected request type " + (Object)((Object)apiKey));
            }
        }
        responseFuture.whenComplete((response, exception) -> {
            ApiMessage message = response != null ? response : RaftUtil.errorResponse(apiKey, Errors.forException(exception));
            RaftResponse.Outbound responseMessage = new RaftResponse.Outbound(request.correlationId(), message);
            request.completion.complete(responseMessage);
            this.logger.trace("Sent response {} to inbound request {}", (Object)responseMessage, (Object)request);
        });
    }

    private void handleInboundMessage(RaftMessage message, long currentTimeMs) throws IOException {
        this.logger.trace("Received inbound message {}", (Object)message);
        if (message instanceof RaftRequest.Inbound) {
            RaftRequest.Inbound request = (RaftRequest.Inbound)message;
            this.handleRequest(request, currentTimeMs);
        } else if (message instanceof RaftResponse.Inbound) {
            RaftResponse.Inbound response = (RaftResponse.Inbound)message;
            RequestManager.ConnectionState connection = this.requestManager.getOrCreate(response.sourceId());
            if (connection.isResponseExpected(response.correlationId)) {
                this.handleResponse(response, currentTimeMs);
            } else {
                this.logger.debug("Ignoring response {} since it is no longer needed", (Object)response);
            }
        } else {
            throw new IllegalArgumentException("Unexpected message " + message);
        }
    }

    private long maybeSendRequest(long currentTimeMs, int destinationId, Supplier<ApiMessage> requestSupplier) {
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(destinationId);
        if (connection.isBackingOff(currentTimeMs)) {
            long remainingBackoffMs = connection.remainingBackoffMs(currentTimeMs);
            this.logger.debug("Connection for {} is backing off for {} ms", (Object)destinationId, (Object)remainingBackoffMs);
            return remainingBackoffMs;
        }
        if (connection.isReady(currentTimeMs)) {
            int correlationId = this.channel.newCorrelationId();
            ApiMessage request = requestSupplier.get();
            RaftRequest.Outbound requestMessage = new RaftRequest.Outbound(correlationId, request, destinationId, currentTimeMs);
            requestMessage.completion.whenComplete((response, exception) -> {
                if (exception != null) {
                    ApiKeys api = ApiKeys.forId(request.apiKey());
                    Errors error = Errors.forException(exception);
                    ApiMessage errorResponse = RaftUtil.errorResponse(api, error);
                    response = new RaftResponse.Inbound(correlationId, errorResponse, destinationId);
                }
                this.messageQueue.add((RaftMessage)response);
            });
            this.channel.send(requestMessage);
            this.logger.trace("Sent outbound request: {}", (Object)requestMessage);
            connection.onRequestSent(correlationId, currentTimeMs);
            return Long.MAX_VALUE;
        }
        return connection.remainingRequestTimeMs(currentTimeMs);
    }

    private EndQuorumEpochRequestData buildEndQuorumEpochRequest(ResignedState state) {
        return EndQuorumEpochRequest.singletonRequest(this.log.topicPartition(), this.quorum.epoch(), this.quorum.localIdOrThrow(), state.preferredSuccessors());
    }

    private long maybeSendRequests(long currentTimeMs, Set<Integer> destinationIds, Supplier<ApiMessage> requestSupplier) {
        long minBackoffMs = Long.MAX_VALUE;
        for (Integer destinationId : destinationIds) {
            long backoffMs = this.maybeSendRequest(currentTimeMs, destinationId, requestSupplier);
            if (backoffMs >= minBackoffMs) continue;
            minBackoffMs = backoffMs;
        }
        return minBackoffMs;
    }

    private BeginQuorumEpochRequestData buildBeginQuorumEpochRequest() {
        return BeginQuorumEpochRequest.singletonRequest(this.log.topicPartition(), this.quorum.epoch(), this.quorum.localIdOrThrow());
    }

    private VoteRequestData buildVoteRequest() {
        OffsetAndEpoch endOffset = this.endOffset();
        return VoteRequest.singletonRequest(this.log.topicPartition(), this.quorum.epoch(), this.quorum.localIdOrThrow(), endOffset.epoch, endOffset.offset);
    }

    private FetchRequestData buildFetchRequest() {
        FetchRequestData request = RaftUtil.singletonFetchRequest(this.log.topicPartition(), fetchPartition -> fetchPartition.setCurrentLeaderEpoch(this.quorum.epoch()).setLastFetchedEpoch(this.log.lastFetchedEpoch()).setFetchOffset(this.log.endOffset().offset));
        return request.setMaxBytes(0x800000).setMaxWaitMs(this.fetchMaxWaitMs).setClusterId(this.clusterId).setReplicaId(this.quorum.localIdOrSentinel());
    }

    private long maybeSendAnyVoterFetch(long currentTimeMs) {
        OptionalInt readyVoterIdOpt = this.requestManager.findReadyVoter(currentTimeMs);
        if (readyVoterIdOpt.isPresent()) {
            return this.maybeSendRequest(currentTimeMs, readyVoterIdOpt.getAsInt(), this::buildFetchRequest);
        }
        return this.requestManager.backoffBeforeAvailableVoter(currentTimeMs);
    }

    private FetchSnapshotRequestData buildFetchSnapshotRequest(OffsetAndEpoch snapshotId, long snapshotSize) {
        FetchSnapshotRequestData.SnapshotId requestSnapshotId = new FetchSnapshotRequestData.SnapshotId().setEpoch(snapshotId.epoch).setEndOffset(snapshotId.offset);
        FetchSnapshotRequestData request = FetchSnapshotRequest.singleton(this.log.topicPartition(), snapshotPartition -> snapshotPartition.setCurrentLeaderEpoch(this.quorum.epoch()).setSnapshotId(requestSnapshotId).setPosition(snapshotSize));
        return request.setReplicaId(this.quorum.localIdOrSentinel());
    }

    private FetchSnapshotResponseData.PartitionSnapshot addQuorumLeader(FetchSnapshotResponseData.PartitionSnapshot partitionSnapshot) {
        partitionSnapshot.currentLeader().setLeaderEpoch(this.quorum.epoch()).setLeaderId(this.quorum.leaderIdOrSentinel());
        return partitionSnapshot;
    }

    public boolean isRunning() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown == null || !gracefulShutdown.isFinished();
    }

    public boolean isShuttingDown() {
        GracefulShutdown gracefulShutdown = this.shutdown.get();
        return gracefulShutdown != null && !gracefulShutdown.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendBatch(LeaderState state, BatchAccumulator.CompletedBatch<T> batch, long appendTimeMs) {
        try {
            int epoch = state.epoch();
            LogAppendInfo info = this.appendAsLeader(batch.data);
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(info.lastOffset, epoch);
            CompletableFuture<Long> future = this.appendPurgatory.await(offsetAndEpoch.offset + 1L, Integer.MAX_VALUE);
            future.whenComplete((commitTimeMs, exception) -> {
                int numRecords = batch.records.size();
                if (exception != null) {
                    this.logger.debug("Failed to commit {} records at {}", numRecords, offsetAndEpoch, exception);
                } else {
                    long elapsedTime = Math.max(0L, commitTimeMs - appendTimeMs);
                    double elapsedTimePerRecord = (double)elapsedTime / (double)numRecords;
                    this.kafkaRaftMetrics.updateCommitLatency(elapsedTimePerRecord, appendTimeMs);
                    this.logger.debug("Completed commit of {} records at {}", (Object)numRecords, (Object)offsetAndEpoch);
                    this.maybeFireHandleCommit(batch.baseOffset, epoch, batch.records);
                }
            });
        }
        finally {
            batch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long maybeAppendBatches(LeaderState state, long currentTimeMs) {
        long timeUnitFlush = this.accumulator.timeUntilDrain(currentTimeMs);
        if (timeUnitFlush <= 0L) {
            List<BatchAccumulator.CompletedBatch<T>> batches = this.accumulator.drain();
            Iterator<BatchAccumulator.CompletedBatch<T>> iterator = batches.iterator();
            try {
                while (iterator.hasNext()) {
                    BatchAccumulator.CompletedBatch<T> batch = iterator.next();
                    this.appendBatch(state, batch, currentTimeMs);
                }
                this.flushLeaderLog(state, currentTimeMs);
            }
            finally {
                while (iterator.hasNext()) {
                    iterator.next().release();
                }
            }
        }
        return timeUnitFlush;
    }

    private long pollResigned(long currentTimeMs) throws IOException {
        long stateTimeoutMs;
        ResignedState state = this.quorum.resignedStateOrThrow();
        long endQuorumBackoffMs = this.maybeSendRequests(currentTimeMs, state.unackedVoters(), () -> this.buildEndQuorumEpochRequest(state));
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            stateTimeoutMs = shutdown.remainingTimeMs();
        } else if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            stateTimeoutMs = 0L;
        } else {
            stateTimeoutMs = state.remainingElectionTimeMs(currentTimeMs);
        }
        return Math.min(stateTimeoutMs, endQuorumBackoffMs);
    }

    private long pollLeader(long currentTimeMs) {
        LeaderState state = this.quorum.leaderStateOrThrow();
        this.maybeFireHandleClaim(state);
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            this.transitionToResigned(state.nonLeaderVotersByDescendingFetchOffset());
            return 0L;
        }
        long timeUntilFlush = this.maybeAppendBatches(state, currentTimeMs);
        long timeUntilSend = this.maybeSendRequests(currentTimeMs, state.nonAcknowledgingVoters(), this::buildBeginQuorumEpochRequest);
        return Math.min(timeUntilFlush, timeUntilSend);
    }

    private long maybeSendVoteRequests(CandidateState state, long currentTimeMs) {
        if (!state.isVoteRejected()) {
            return this.maybeSendRequests(currentTimeMs, state.unrecordedVoters(), this::buildVoteRequest);
        }
        return Long.MAX_VALUE;
    }

    private long pollCandidate(long currentTimeMs) throws IOException {
        CandidateState state = this.quorum.candidateStateOrThrow();
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            long minRequestBackoffMs = this.maybeSendVoteRequests(state, currentTimeMs);
            return Math.min(shutdown.remainingTimeMs(), minRequestBackoffMs);
        }
        if (state.isBackingOff()) {
            if (state.isBackoffComplete(currentTimeMs)) {
                this.logger.info("Re-elect as candidate after election backoff has completed");
                this.transitionToCandidate(currentTimeMs);
                return 0L;
            }
            return state.remainingBackoffMs(currentTimeMs);
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            long backoffDurationMs = this.binaryExponentialElectionBackoffMs(state.retries());
            this.logger.debug("Election has timed out, backing off for {}ms before becoming a candidate again", (Object)backoffDurationMs);
            state.startBackingOff(currentTimeMs, backoffDurationMs);
            return backoffDurationMs;
        }
        long minRequestBackoffMs = this.maybeSendVoteRequests(state, currentTimeMs);
        return Math.min(minRequestBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
    }

    private long pollFollower(long currentTimeMs) throws IOException {
        FollowerState state = this.quorum.followerStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollFollowerAsVoter(state, currentTimeMs);
        }
        return this.pollFollowerAsObserver(state, currentTimeMs);
    }

    private long pollFollowerAsVoter(FollowerState state, long currentTimeMs) throws IOException {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return 0L;
        }
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            this.logger.info("Become candidate due to fetch timeout");
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        long backoffMs = this.maybeSendFetchOrFetchSnapshot(state, currentTimeMs);
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long pollFollowerAsObserver(FollowerState state, long currentTimeMs) throws IOException {
        long backoffMs;
        if (state.hasFetchTimeoutExpired(currentTimeMs)) {
            return this.maybeSendAnyVoterFetch(currentTimeMs);
        }
        RequestManager.ConnectionState connection = this.requestManager.getOrCreate(state.leaderId());
        if (connection.hasRequestTimedOut(currentTimeMs)) {
            backoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
            connection.reset();
        } else {
            backoffMs = connection.isBackingOff(currentTimeMs) ? this.maybeSendAnyVoterFetch(currentTimeMs) : this.maybeSendFetchOrFetchSnapshot(state, currentTimeMs);
        }
        return Math.min(backoffMs, state.remainingFetchTimeMs(currentTimeMs));
    }

    private long maybeSendFetchOrFetchSnapshot(FollowerState state, long currentTimeMs) throws IOException {
        Supplier<ApiMessage> requestSupplier;
        if (state.fetchingSnapshot().isPresent()) {
            RawSnapshotWriter snapshot = state.fetchingSnapshot().get();
            long snapshotSize = snapshot.sizeInBytes();
            requestSupplier = () -> this.buildFetchSnapshotRequest(snapshot.snapshotId(), snapshotSize);
        } else {
            requestSupplier = this::buildFetchRequest;
        }
        return this.maybeSendRequest(currentTimeMs, state.leaderId(), requestSupplier);
    }

    private long pollVoted(long currentTimeMs) throws IOException {
        VotedState state = this.quorum.votedStateOrThrow();
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return shutdown.remainingTimeMs();
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattached(long currentTimeMs) throws IOException {
        UnattachedState state = this.quorum.unattachedStateOrThrow();
        if (this.quorum.isVoter()) {
            return this.pollUnattachedAsVoter(state, currentTimeMs);
        }
        return this.pollUnattachedAsObserver(state, currentTimeMs);
    }

    private long pollUnattachedAsVoter(UnattachedState state, long currentTimeMs) throws IOException {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown != null) {
            return shutdown.remainingTimeMs();
        }
        if (state.hasElectionTimeoutExpired(currentTimeMs)) {
            this.transitionToCandidate(currentTimeMs);
            return 0L;
        }
        return state.remainingElectionTimeMs(currentTimeMs);
    }

    private long pollUnattachedAsObserver(UnattachedState state, long currentTimeMs) {
        long fetchBackoffMs = this.maybeSendAnyVoterFetch(currentTimeMs);
        return Math.min(fetchBackoffMs, state.remainingElectionTimeMs(currentTimeMs));
    }

    private long pollCurrentState(long currentTimeMs) throws IOException {
        this.maybeUpdateOldestSnapshotId();
        if (this.quorum.isLeader()) {
            return this.pollLeader(currentTimeMs);
        }
        if (this.quorum.isCandidate()) {
            return this.pollCandidate(currentTimeMs);
        }
        if (this.quorum.isFollower()) {
            return this.pollFollower(currentTimeMs);
        }
        if (this.quorum.isVoted()) {
            return this.pollVoted(currentTimeMs);
        }
        if (this.quorum.isUnattached()) {
            return this.pollUnattached(currentTimeMs);
        }
        if (this.quorum.isResigned()) {
            return this.pollResigned(currentTimeMs);
        }
        throw new IllegalStateException("Unexpected quorum state " + this.quorum);
    }

    private void pollListeners() {
        while (!this.pendingListeners.isEmpty()) {
            RaftClient.Listener<T> listener = this.pendingListeners.poll();
            this.listenerContexts.add(new ListenerContext(listener));
        }
        this.quorum.highWatermark().ifPresent(highWatermarkMetadata -> {
            long highWatermark = highWatermarkMetadata.offset;
            List<ListenerContext> listenersToUpdate = this.listenerContexts.stream().filter(listenerContext -> {
                OptionalLong nextExpectedOffset = listenerContext.nextExpectedOffset();
                return nextExpectedOffset.isPresent() && nextExpectedOffset.getAsLong() < highWatermark;
            }).collect(Collectors.toList());
            this.updateListenersProgress(listenersToUpdate, highWatermarkMetadata.offset);
        });
    }

    private boolean maybeCompleteShutdown(long currentTimeMs) {
        GracefulShutdown shutdown = this.shutdown.get();
        if (shutdown == null) {
            return false;
        }
        shutdown.update(currentTimeMs);
        if (shutdown.hasTimedOut()) {
            shutdown.failWithTimeout();
            return true;
        }
        if (this.quorum.isObserver() || this.quorum.remoteVoters().isEmpty() || this.quorum.hasRemoteLeader()) {
            shutdown.complete();
            return true;
        }
        return false;
    }

    private void maybeUpdateOldestSnapshotId() {
        this.log.latestSnapshotId().ifPresent(snapshotId -> this.log.deleteBeforeSnapshot((OffsetAndEpoch)snapshotId));
    }

    private void wakeup() {
        this.messageQueue.wakeup();
    }

    public void handle(RaftRequest.Inbound request) {
        this.messageQueue.add(Objects.requireNonNull(request));
    }

    public void poll() throws IOException {
        this.pollListeners();
        long currentTimeMs = this.time.milliseconds();
        if (this.maybeCompleteShutdown(currentTimeMs)) {
            return;
        }
        long pollTimeoutMs = this.pollCurrentState(currentTimeMs);
        this.kafkaRaftMetrics.updatePollStart(currentTimeMs);
        RaftMessage message = this.messageQueue.poll(pollTimeoutMs);
        currentTimeMs = this.time.milliseconds();
        this.kafkaRaftMetrics.updatePollEnd(currentTimeMs);
        if (message != null) {
            this.handleInboundMessage(message, currentTimeMs);
        }
    }

    @Override
    public Long scheduleAppend(int epoch, List<T> records) {
        return this.append(epoch, records, false);
    }

    @Override
    public Long scheduleAtomicAppend(int epoch, List<T> records) {
        return this.append(epoch, records, true);
    }

    private Long append(int epoch, List<T> records, boolean isAtomic) {
        BatchAccumulator<T> accumulator = this.accumulator;
        if (accumulator == null) {
            return Long.MAX_VALUE;
        }
        boolean isFirstAppend = accumulator.isEmpty();
        Long offset = isAtomic ? accumulator.appendAtomic(epoch, records) : accumulator.append(epoch, records);
        if (isFirstAppend || accumulator.needsDrain(this.time.milliseconds())) {
            this.wakeup();
        }
        return offset;
    }

    @Override
    public CompletableFuture<Void> shutdown(int timeoutMs) {
        this.logger.info("Beginning graceful shutdown");
        CompletableFuture<Void> shutdownComplete = new CompletableFuture<Void>();
        this.shutdown.set(new GracefulShutdown(timeoutMs, shutdownComplete));
        this.wakeup();
        return shutdownComplete;
    }

    @Override
    public SnapshotWriter<T> createSnapshot(OffsetAndEpoch snapshotId) throws IOException {
        return new SnapshotWriter<T>(this.log.createSnapshot(snapshotId), 0x800000, this.memoryPool, this.time, CompressionType.NONE, this.serde);
    }

    @Override
    public void close() {
        if (this.kafkaRaftMetrics != null) {
            this.kafkaRaftMetrics.close();
        }
    }

    QuorumState quorum() {
        return this.quorum;
    }

    public OptionalLong highWatermark() {
        return this.quorum.highWatermark().isPresent() ? OptionalLong.of(this.quorum.highWatermark().get().offset) : OptionalLong.empty();
    }

    private final class ListenerContext
    implements CloseListener<BatchReader<T>> {
        private final RaftClient.Listener<T> listener;
        private int claimedEpoch = 0;
        private BatchReader<T> lastSent = null;
        private long nextOffset = 0L;

        private ListenerContext(RaftClient.Listener<T> listener) {
            this.listener = listener;
        }

        public synchronized long nextOffset() {
            return this.nextOffset;
        }

        public synchronized OptionalLong nextExpectedOffset() {
            if (this.lastSent != null) {
                OptionalLong lastSentOffset = this.lastSent.lastOffset();
                if (lastSentOffset.isPresent()) {
                    return OptionalLong.of(lastSentOffset.getAsLong() + 1L);
                }
                return OptionalLong.empty();
            }
            return OptionalLong.of(this.nextOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireHandleSnapshot(long logStartOffset) {
            ListenerContext listenerContext = this;
            synchronized (listenerContext) {
                this.nextOffset = logStartOffset;
                this.lastSent = null;
            }
        }

        public void fireHandleCommit(long baseOffset, Records records) {
            BufferSupplier bufferSupplier = BufferSupplier.create();
            RecordsBatchReader reader = new RecordsBatchReader(baseOffset, records, KafkaRaftClient.this.serde, bufferSupplier, this);
            this.fireHandleCommit(reader);
        }

        public void fireHandleCommit(long baseOffset, int epoch, List<T> records) {
            BatchReader.Batch batch = new BatchReader.Batch(baseOffset, epoch, records);
            MemoryBatchReader reader = new MemoryBatchReader(Collections.singletonList(batch), this);
            this.fireHandleCommit(reader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireHandleCommit(BatchReader<T> reader) {
            ListenerContext listenerContext = this;
            synchronized (listenerContext) {
                this.lastSent = reader;
            }
            this.listener.handleCommit(reader);
        }

        void maybeFireHandleClaim(int epoch, long epochStartOffset) {
            if (epoch > this.claimedEpoch && this.nextOffset() >= epochStartOffset) {
                this.claimedEpoch = epoch;
                this.listener.handleClaim(epoch);
            }
        }

        void fireHandleResign(int epoch) {
            this.listener.handleResign(epoch);
        }

        @Override
        public synchronized void onClose(BatchReader<T> reader) {
            OptionalLong lastOffset = reader.lastOffset();
            if (lastOffset.isPresent()) {
                this.nextOffset = lastOffset.getAsLong() + 1L;
            }
            if (this.lastSent == reader) {
                this.lastSent = null;
                KafkaRaftClient.this.wakeup();
            }
        }
    }

    private class GracefulShutdown {
        final Timer finishTimer;
        final CompletableFuture<Void> completeFuture;

        public GracefulShutdown(long shutdownTimeoutMs, CompletableFuture<Void> completeFuture) {
            this.finishTimer = KafkaRaftClient.this.time.timer(shutdownTimeoutMs);
            this.completeFuture = completeFuture;
        }

        public void update(long currentTimeMs) {
            this.finishTimer.update(currentTimeMs);
        }

        public boolean hasTimedOut() {
            return this.finishTimer.isExpired();
        }

        public boolean isFinished() {
            return this.completeFuture.isDone();
        }

        public long remainingTimeMs() {
            return this.finishTimer.remainingMs();
        }

        public void failWithTimeout() {
            KafkaRaftClient.this.logger.warn("Graceful shutdown timed out after {}ms", (Object)this.finishTimer.timeoutMs());
            this.completeFuture.completeExceptionally(new TimeoutException("Timeout expired before graceful shutdown completed"));
        }

        public void complete() {
            KafkaRaftClient.this.logger.info("Graceful shutdown completed");
            this.completeFuture.complete(null);
        }
    }
}

