/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.raft;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ShortNode;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Utils;
import org.apache.pinot.shaded.org.apache.kafka.raft.ElectionState;
import org.apache.pinot.shaded.org.apache.kafka.raft.QuorumStateStore;
import org.apache.pinot.shaded.org.apache.kafka.raft.generated.QuorumStateData;
import org.apache.pinot.shaded.org.apache.kafka.raft.generated.QuorumStateDataJsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedStateStore
implements QuorumStateStore {
    private static final Logger log = LoggerFactory.getLogger(FileBasedStateStore.class);
    private final File stateFile;
    static final String DATA_VERSION = "data_version";

    public FileBasedStateStore(File stateFile) {
        this.stateFile = stateFile;
    }

    private QuorumStateData readStateFromFile(File file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file.toPath());){
            String line = reader.readLine();
            if (line == null) {
                throw new EOFException("File ended prematurely.");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode readNode = objectMapper.readTree(line);
            if (!(readNode instanceof ObjectNode)) {
                throw new IOException("Deserialized node " + readNode + " is not an object node");
            }
            ObjectNode dataObject = (ObjectNode)readNode;
            JsonNode dataVersionNode = dataObject.get(DATA_VERSION);
            if (dataVersionNode == null) {
                throw new IOException("Deserialized node " + readNode + " does not have " + DATA_VERSION + " field");
            }
            short dataVersion = dataVersionNode.shortValue();
            QuorumStateData quorumStateData = QuorumStateDataJsonConverter.read(dataObject, dataVersion);
            return quorumStateData;
        }
    }

    @Override
    public ElectionState readElectionState() throws IOException {
        if (!this.stateFile.exists()) {
            return null;
        }
        QuorumStateData data = this.readStateFromFile(this.stateFile);
        return new ElectionState(data.leaderEpoch(), data.leaderId() == -1 ? OptionalInt.empty() : OptionalInt.of(data.leaderId()), data.votedId() == -1 ? OptionalInt.empty() : OptionalInt.of(data.votedId()), data.currentVoters().stream().map(QuorumStateData.Voter::voterId).collect(Collectors.toSet()));
    }

    @Override
    public void writeElectionState(ElectionState latest) throws IOException {
        QuorumStateData data = new QuorumStateData().setLeaderEpoch(latest.epoch).setVotedId(latest.hasVoted() ? latest.votedId() : -1).setLeaderId(latest.hasLeader() ? latest.leaderId() : -1).setCurrentVoters(this.voters(latest.voters()));
        this.writeElectionStateToFile(this.stateFile, data);
    }

    private List<QuorumStateData.Voter> voters(Set<Integer> votersId) {
        return votersId.stream().map(voterId -> new QuorumStateData.Voter().setVoterId((int)voterId)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElectionStateToFile(File stateFile, QuorumStateData state) throws IOException {
        File temp = new File(stateFile.getAbsolutePath() + ".tmp");
        Files.deleteIfExists(temp.toPath());
        log.trace("Writing tmp quorum state {}", (Object)temp.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(temp);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
            short version = state.highestSupportedVersion();
            ObjectNode jsonState = (ObjectNode)QuorumStateDataJsonConverter.write(state, version);
            jsonState.set(DATA_VERSION, new ShortNode(version));
            writer.write(jsonState.toString());
            writer.flush();
            fileOutputStream.getFD().sync();
            Utils.atomicMoveWithFallback(temp.toPath(), stateFile.toPath());
        }
        finally {
            Files.deleteIfExists(temp.toPath());
        }
    }

    @Override
    public void clear() throws IOException {
        Files.deleteIfExists(this.stateFile.toPath());
        Files.deleteIfExists(new File(this.stateFile.getAbsolutePath() + ".tmp").toPath());
    }

    public String toString() {
        return "Quorum state filepath: " + this.stateFile.getAbsolutePath();
    }
}

