/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.controller;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pinot.shaded.org.apache.kafka.metadata.ApiMessageAndVersion;

class ControllerResult<T> {
    private final List<ApiMessageAndVersion> records;
    private final T response;
    private final boolean isAtomic;

    protected ControllerResult(List<ApiMessageAndVersion> records, T response, boolean isAtomic) {
        Objects.requireNonNull(records);
        this.records = records;
        this.response = response;
        this.isAtomic = isAtomic;
    }

    public List<ApiMessageAndVersion> records() {
        return this.records;
    }

    public T response() {
        return this.response;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ControllerResult other = (ControllerResult)o;
        return this.records.equals(other.records) && Objects.equals(this.response, other.response) && Objects.equals(this.isAtomic, other.isAtomic);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.response, this.isAtomic);
    }

    public String toString() {
        return String.format("ControllerResult(records=%s, response=%s, isAtomic=%s)", String.join((CharSequence)",", this.records.stream().map(ApiMessageAndVersion::toString).collect(Collectors.toList())), this.response, this.isAtomic);
    }

    public ControllerResult<T> withoutRecords() {
        return new ControllerResult<T>(Collections.emptyList(), this.response, false);
    }

    public static <T> ControllerResult<T> atomicOf(List<ApiMessageAndVersion> records, T response) {
        return new ControllerResult<T>(records, response, true);
    }

    public static <T> ControllerResult<T> of(List<ApiMessageAndVersion> records, T response) {
        return new ControllerResult<T>(records, response, false);
    }
}

