/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.controller;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.config.ConfigResource;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.pinot.shaded.org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.pinot.shaded.org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.pinot.shaded.org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.pinot.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.pinot.shaded.org.apache.kafka.controller.ResultOrError;
import org.apache.pinot.shaded.org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.pinot.shaded.org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.pinot.shaded.org.apache.kafka.metadata.FeatureMapAndEpoch;

public interface Controller
extends AutoCloseable {
    public CompletableFuture<AlterIsrResponseData> alterIsr(AlterIsrRequestData var1);

    public CompletableFuture<CreateTopicsResponseData> createTopics(CreateTopicsRequestData var1);

    public CompletableFuture<Void> unregisterBroker(int var1);

    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(Collection<String> var1);

    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(Collection<Uuid> var1);

    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(Collection<Uuid> var1);

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(Map<ConfigResource, Collection<String>> var1);

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ElectLeadersRequestData var1);

    public CompletableFuture<FeatureMapAndEpoch> finalizedFeatures();

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> var1, boolean var2);

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(Map<ConfigResource, Map<String, String>> var1, boolean var2);

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(BrokerHeartbeatRequestData var1);

    public CompletableFuture<BrokerRegistrationReply> registerBroker(BrokerRegistrationRequestData var1);

    public CompletableFuture<Void> waitForReadyBrokers(int var1);

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(Collection<ClientQuotaAlteration> var1, boolean var2);

    public void beginShutdown();

    public long curClaimEpoch();

    default public boolean isActive() {
        return this.curClaimEpoch() != -1L;
    }

    @Override
    public void close() throws InterruptedException;
}

