/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.security;

import javax.security.auth.login.Configuration;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaasUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JaasUtils.class);
    public static final String JAVA_LOGIN_CONFIG_PARAM = "java.security.auth.login.config";
    public static final String SERVICE_NAME = "serviceName";
    public static final String ZK_SASL_CLIENT = "zookeeper.sasl.client";
    public static final String ZK_LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    private static final String DEFAULT_ZK_LOGIN_CONTEXT_NAME = "Client";
    private static final String DEFAULT_ZK_SASL_CLIENT = "true";

    private JaasUtils() {
    }

    public static String zkSecuritySysConfigString() {
        String loginConfig = System.getProperty(JAVA_LOGIN_CONFIG_PARAM);
        String clientEnabled = System.getProperty(ZK_SASL_CLIENT, "default:true");
        String contextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME_KEY, "default:Client");
        return "[java.security.auth.login.config=" + loginConfig + ", " + ZK_SASL_CLIENT + "=" + clientEnabled + ", " + ZK_LOGIN_CONTEXT_NAME_KEY + "=" + contextName + "]";
    }

    public static boolean isZkSaslEnabled() {
        boolean foundLoginConfigEntry;
        boolean zkSaslEnabled = Boolean.parseBoolean(System.getProperty(ZK_SASL_CLIENT, DEFAULT_ZK_SASL_CLIENT));
        String zkLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME_KEY, DEFAULT_ZK_LOGIN_CONTEXT_NAME);
        LOG.debug("Checking login config for Zookeeper JAAS context {}", (Object)JaasUtils.zkSecuritySysConfigString());
        try {
            Configuration loginConf = Configuration.getConfiguration();
            foundLoginConfigEntry = loginConf.getAppConfigurationEntry(zkLoginContextName) != null;
        }
        catch (Exception e) {
            throw new KafkaException("Exception while loading Zookeeper JAAS login context " + JaasUtils.zkSecuritySysConfigString(), e);
        }
        if (foundLoginConfigEntry && !zkSaslEnabled) {
            LOG.error("JAAS configuration is present, but system property zookeeper.sasl.client is set to false, which disables SASL in the ZooKeeper client");
            throw new KafkaException("Exception while determining if ZooKeeper is secure " + JaasUtils.zkSecuritySysConfigString());
        }
        return foundLoginConfigEntry;
    }
}

