/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.shaded.org.apache.kafka.common.Uuid;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;

public class PartitionRecord
implements ApiMessage {
    int partitionId;
    Uuid topicId;
    List<Integer> replicas;
    List<Integer> isr;
    List<Integer> removingReplicas;
    List<Integer> addingReplicas;
    int leader;
    int leaderEpoch;
    int partitionEpoch;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("partition_id", Type.INT32, "The partition id."), new Field("topic_id", Type.UUID, "The unique ID of this topic."), new Field("replicas", new ArrayOf(Type.INT32), "The replicas of this partition, sorted by preferred order."), new Field("isr", new ArrayOf(Type.INT32), "The in-sync replicas of this partition"), new Field("removing_replicas", ArrayOf.nullable(Type.INT32), "The replicas that we are in the process of removing."), new Field("adding_replicas", ArrayOf.nullable(Type.INT32), "The replicas that we are in the process of adding."), new Field("leader", Type.INT32, "The lead replica, or -1 if there is no leader."), new Field("leader_epoch", Type.INT32, "The epoch of the partition leader."), new Field("partition_epoch", Type.INT32, "An epoch that gets incremented each time we change anything in the partition."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public PartitionRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public PartitionRecord() {
        this.partitionId = -1;
        this.topicId = Uuid.ZERO_UUID;
        this.replicas = new ArrayList<Integer>(0);
        this.isr = new ArrayList<Integer>(0);
        this.removingReplicas = new ArrayList<Integer>(0);
        this.addingReplicas = new ArrayList<Integer>(0);
        this.leader = -1;
        this.leaderEpoch = -1;
        this.partitionEpoch = -1;
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        this.partitionId = _readable.readInt();
        this.topicId = _readable.readUuid();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field replicas was serialized as null");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.replicas = newCollection;
        arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field isr was serialized as null");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.isr = newCollection;
        arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            this.removingReplicas = null;
        } else {
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.removingReplicas = newCollection;
        }
        arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            this.addingReplicas = null;
        } else {
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.addingReplicas = newCollection;
        }
        this.leader = _readable.readInt();
        this.leaderEpoch = _readable.readInt();
        this.partitionEpoch = _readable.readInt();
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.partitionId);
        _writable.writeUuid(this.topicId);
        _writable.writeInt(this.replicas.size());
        for (Integer replicasElement : this.replicas) {
            _writable.writeInt(replicasElement);
        }
        _writable.writeInt(this.isr.size());
        for (Integer isrElement : this.isr) {
            _writable.writeInt(isrElement);
        }
        if (this.removingReplicas == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.removingReplicas.size());
            for (Integer removingReplicasElement : this.removingReplicas) {
                _writable.writeInt(removingReplicasElement);
            }
        }
        if (this.addingReplicas == null) {
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.addingReplicas.size());
            for (Integer addingReplicasElement : this.addingReplicas) {
                _writable.writeInt(addingReplicasElement);
            }
        }
        _writable.writeInt(this.leader);
        _writable.writeInt(this.leaderEpoch);
        _writable.writeInt(this.partitionEpoch);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(4);
        _size.addBytes(this.replicas.size() * 4);
        _size.addBytes(4);
        _size.addBytes(this.isr.size() * 4);
        if (this.removingReplicas == null) {
            _size.addBytes(4);
        } else {
            _size.addBytes(4);
            _size.addBytes(this.removingReplicas.size() * 4);
        }
        if (this.addingReplicas == null) {
            _size.addBytes(4);
        } else {
            _size.addBytes(4);
            _size.addBytes(this.addingReplicas.size() * 4);
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionRecord)) {
            return false;
        }
        PartitionRecord other = (PartitionRecord)obj;
        if (this.partitionId != other.partitionId) {
            return false;
        }
        if (!this.topicId.equals(other.topicId)) {
            return false;
        }
        if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
            return false;
        }
        if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
            return false;
        }
        if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
            return false;
        }
        if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
            return false;
        }
        if (this.leader != other.leader) {
            return false;
        }
        if (this.leaderEpoch != other.leaderEpoch) {
            return false;
        }
        if (this.partitionEpoch != other.partitionEpoch) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.partitionId;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
        hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
        hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
        hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
        hashCode = 31 * hashCode + this.leader;
        hashCode = 31 * hashCode + this.leaderEpoch;
        hashCode = 31 * hashCode + this.partitionEpoch;
        return hashCode;
    }

    @Override
    public PartitionRecord duplicate() {
        PartitionRecord _duplicate = new PartitionRecord();
        _duplicate.partitionId = this.partitionId;
        _duplicate.topicId = this.topicId;
        ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
        for (Integer n : this.replicas) {
            newReplicas.add(n);
        }
        _duplicate.replicas = newReplicas;
        ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
        for (Integer _element : this.isr) {
            newIsr.add(_element);
        }
        _duplicate.isr = newIsr;
        if (this.removingReplicas == null) {
            _duplicate.removingReplicas = null;
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer _element : this.removingReplicas) {
                arrayList.add(_element);
            }
            _duplicate.removingReplicas = arrayList;
        }
        if (this.addingReplicas == null) {
            _duplicate.addingReplicas = null;
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer _element : this.addingReplicas) {
                arrayList.add(_element);
            }
            _duplicate.addingReplicas = arrayList;
        }
        _duplicate.leader = this.leader;
        _duplicate.leaderEpoch = this.leaderEpoch;
        _duplicate.partitionEpoch = this.partitionEpoch;
        return _duplicate;
    }

    public String toString() {
        return "PartitionRecord(partitionId=" + this.partitionId + ", topicId=" + this.topicId.toString() + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", removingReplicas=" + (this.removingReplicas == null ? "null" : MessageUtil.deepToString(this.removingReplicas.iterator())) + ", addingReplicas=" + (this.addingReplicas == null ? "null" : MessageUtil.deepToString(this.addingReplicas.iterator())) + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", partitionEpoch=" + this.partitionEpoch + ")";
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> isr() {
        return this.isr;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public int leader() {
        return this.leader;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int partitionEpoch() {
        return this.partitionEpoch;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PartitionRecord setPartitionId(int v) {
        this.partitionId = v;
        return this;
    }

    public PartitionRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public PartitionRecord setReplicas(List<Integer> v) {
        this.replicas = v;
        return this;
    }

    public PartitionRecord setIsr(List<Integer> v) {
        this.isr = v;
        return this;
    }

    public PartitionRecord setRemovingReplicas(List<Integer> v) {
        this.removingReplicas = v;
        return this;
    }

    public PartitionRecord setAddingReplicas(List<Integer> v) {
        this.addingReplicas = v;
        return this;
    }

    public PartitionRecord setLeader(int v) {
        this.leader = v;
        return this;
    }

    public PartitionRecord setLeaderEpoch(int v) {
        this.leaderEpoch = v;
        return this;
    }

    public PartitionRecord setPartitionEpoch(int v) {
        this.partitionEpoch = v;
        return this;
    }
}

