/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.pinot.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.pinot.shaded.org.apache.kafka.common.record.BaseRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ProduceRequestData
implements ApiMessage {
    String transactionalId;
    short acks;
    int timeoutMs;
    TopicProduceDataCollection topicData;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 9;

    public ProduceRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ProduceRequestData() {
        this.transactionalId = null;
        this.acks = 0;
        this.timeoutMs = 0;
        this.topicData = new TopicProduceDataCollection(0);
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 9;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        TopicProduceDataCollection newCollection;
        int arrayLength;
        if (_version >= 3) {
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.transactionalId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field transactionalId had invalid length " + length);
                }
                this.transactionalId = _readable.readString(length);
            }
        } else {
            this.transactionalId = null;
        }
        this.acks = _readable.readShort();
        this.timeoutMs = _readable.readInt();
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicData was serialized as null");
            }
            newCollection = new TopicProduceDataCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicProduceData(_readable, _version));
            }
            this.topicData = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicData was serialized as null");
            }
            newCollection = new TopicProduceDataCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicProduceData(_readable, _version));
            }
            this.topicData = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.transactionalId);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (this.transactionalId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactionalId at version " + _version);
        }
        _writable.writeShort(this.acks);
        _writable.writeInt(this.timeoutMs);
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.topicData.size() + 1);
            _stringBytes = this.topicData.iterator();
            while (_stringBytes.hasNext()) {
                TopicProduceData topicDataElement = (TopicProduceData)_stringBytes.next();
                topicDataElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topicData.size());
            _stringBytes = this.topicData.iterator();
            while (_stringBytes.hasNext()) {
                TopicProduceData topicDataElement = (TopicProduceData)_stringBytes.next();
                topicDataElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 3) {
            if (this.transactionalId == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'transactionalId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
                if (_version >= 9) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
        }
        _size.addBytes(2);
        _size.addBytes(4);
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicData.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (TopicProduceData topicDataElement : this.topicData) {
            topicDataElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceRequestData)) {
            return false;
        }
        ProduceRequestData other = (ProduceRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.acks != other.acks) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.topicData == null ? other.topicData != null : !this.topicData.equals(other.topicData)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + this.acks;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.topicData == null ? 0 : this.topicData.hashCode());
        return hashCode;
    }

    @Override
    public ProduceRequestData duplicate() {
        ProduceRequestData _duplicate = new ProduceRequestData();
        _duplicate.transactionalId = this.transactionalId == null ? null : this.transactionalId;
        _duplicate.acks = this.acks;
        _duplicate.timeoutMs = this.timeoutMs;
        TopicProduceDataCollection newTopicData = new TopicProduceDataCollection(this.topicData.size());
        for (TopicProduceData _element : this.topicData) {
            newTopicData.add(_element.duplicate());
        }
        _duplicate.topicData = newTopicData;
        return _duplicate;
    }

    public String toString() {
        return "ProduceRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", acks=" + this.acks + ", timeoutMs=" + this.timeoutMs + ", topicData=" + MessageUtil.deepToString(this.topicData.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public short acks() {
        return this.acks;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public TopicProduceDataCollection topicData() {
        return this.topicData;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProduceRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public ProduceRequestData setAcks(short v) {
        this.acks = v;
        return this;
    }

    public ProduceRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public ProduceRequestData setTopicData(TopicProduceDataCollection v) {
        this.topicData = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topic_data", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to.")));
        SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("transactional_id", Type.NULLABLE_STRING, "The transactional ID, or null if the producer is not transactional."), new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topic_data", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to."))))));
        SCHEMA_9 = new Schema(new Field("transactional_id", Type.COMPACT_NULLABLE_STRING, "The transactional ID, or null if the producer is not transactional."), new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topic_data", new CompactArrayOf(TopicProduceData.SCHEMA_9), "Each topic to produce to."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
    }

    public static class TopicProduceDataCollection
    extends ImplicitLinkedHashMultiCollection<TopicProduceData> {
        public TopicProduceDataCollection() {
        }

        public TopicProduceDataCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicProduceDataCollection(Iterator<TopicProduceData> iterator) {
            super(iterator);
        }

        @Override
        public TopicProduceData find(String name) {
            TopicProduceData _key = new TopicProduceData();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<TopicProduceData> findAll(String name) {
            TopicProduceData _key = new TopicProduceData();
            _key.setName(name);
            return this.findAll(_key);
        }

        public TopicProduceDataCollection duplicate() {
            TopicProduceDataCollection _duplicate = new TopicProduceDataCollection(this.size());
            for (TopicProduceData _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class PartitionProduceData
    implements Message {
        int index;
        BaseRecords records;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public PartitionProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionProduceData() {
            this.index = 0;
            this.records = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 9;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceData");
            }
            this.index = _readable.readInt();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            this.records = length < 0 ? null : _readable.readRecords(length);
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.index);
            if (this.records == null) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeInt(-1);
                }
            } else {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(this.records.sizeInBytes() + 1);
                } else {
                    _writable.writeInt(this.records.sizeInBytes());
                }
                _writable.writeRecords(this.records);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionProduceData");
            }
            _size.addBytes(4);
            if (this.records == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(4);
                }
            } else {
                _size.addZeroCopyBytes(this.records.sizeInBytes());
                if (_version >= 9) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.records.sizeInBytes() + 1));
                } else {
                    _size.addBytes(4);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceData)) {
                return false;
            }
            PartitionProduceData other = (PartitionProduceData)obj;
            if (this.index != other.index) {
                return false;
            }
            if (!Objects.equals(this.records, other.records)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.index;
            hashCode = 31 * hashCode + Objects.hashCode(this.records);
            return hashCode;
        }

        @Override
        public PartitionProduceData duplicate() {
            PartitionProduceData _duplicate = new PartitionProduceData();
            _duplicate.index = this.index;
            _duplicate.records = this.records == null ? null : MemoryRecords.readableRecords(((MemoryRecords)this.records).buffer().duplicate());
            return _duplicate;
        }

        public String toString() {
            return "PartitionProduceData(index=" + this.index + ", records=" + this.records + ")";
        }

        public int index() {
            return this.index;
        }

        public BaseRecords records() {
            return this.records;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionProduceData setIndex(int v) {
            this.index = v;
            return this;
        }

        public PartitionProduceData setRecords(BaseRecords v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("records", Type.RECORDS, "The record data to be produced.")))))))));
            SCHEMA_9 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("records", Type.COMPACT_RECORDS, "The record data to be produced."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }

    public static class TopicProduceData
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<PartitionProduceData> partitionData;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public TopicProduceData(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public TopicProduceData() {
            this.name = "";
            this.partitionData = new ArrayList<PartitionProduceData>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 9;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<PartitionProduceData> newCollection;
            int arrayLength;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceData");
            }
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            if (_version >= 9) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionData was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionProduceData(_readable, _version));
                }
                this.partitionData = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionData was serialized as null");
                }
                newCollection = new ArrayList<PartitionProduceData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionProduceData(_readable, _version));
                }
                this.partitionData = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.partitionData.size() + 1);
                _stringBytes = this.partitionData.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionProduceData partitionDataElement = (PartitionProduceData)_stringBytes.next();
                    partitionDataElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionData.size());
                _stringBytes = this.partitionData.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionProduceData partitionDataElement = (PartitionProduceData)_stringBytes.next();
                    partitionDataElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicProduceData");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 9) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionData.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (PartitionProduceData partitionDataElement : this.partitionData) {
                partitionDataElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicProduceData)) {
                return false;
            }
            TopicProduceData other = (TopicProduceData)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceData)) {
                return false;
            }
            TopicProduceData other = (TopicProduceData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionData == null ? other.partitionData != null : !this.partitionData.equals(other.partitionData)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public TopicProduceData duplicate() {
            TopicProduceData _duplicate = new TopicProduceData();
            _duplicate.name = this.name;
            ArrayList<PartitionProduceData> newPartitionData = new ArrayList<PartitionProduceData>(this.partitionData.size());
            for (PartitionProduceData _element : this.partitionData) {
                newPartitionData.add(_element.duplicate());
            }
            _duplicate.partitionData = newPartitionData;
            return _duplicate;
        }

        public String toString() {
            return "TopicProduceData(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionData=" + MessageUtil.deepToString(this.partitionData.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceData> partitionData() {
            return this.partitionData;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicProduceData setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceData setPartitionData(List<PartitionProduceData> v) {
            this.partitionData = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partition_data", new ArrayOf(PartitionProduceData.SCHEMA_0), "Each partition to produce to.")))))))));
            SCHEMA_9 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partition_data", new CompactArrayOf(PartitionProduceData.SCHEMA_9), "Each partition to produce to."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }
}

