/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20.server;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.shaded.com.google.common.base.Function;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.pinot.shaded.org.apache.kafka.clients.admin.NewTopic;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Time;
import org.apache.pinot.spi.stream.StreamDataServerStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class KafkaDataServerStartable
implements StreamDataServerStartable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaDataServerStartable.class);
    private static final String ZOOKEEPER_CONNECT = "zookeeper.connect";
    private static final String LOG_DIRS = "log.dirs";
    private static final String PORT = "port";
    private KafkaServer _serverStartable;
    private int _port;
    private String _zkStr;
    private String _logDirPath;
    private AdminClient _adminClient;

    public void init(Properties props) {
        this._port = (Integer)props.get(PORT);
        this._zkStr = props.getProperty(ZOOKEEPER_CONNECT);
        this._logDirPath = props.getProperty(LOG_DIRS);
        int indexOfFirstSlash = this._zkStr.indexOf(47);
        if (indexOfFirstSlash != -1) {
            String bareZkUrl = this._zkStr.substring(0, indexOfFirstSlash);
            String zkNodePath = this._zkStr.substring(indexOfFirstSlash);
            ZkClient client = new ZkClient(bareZkUrl);
            client.createPersistent(zkNodePath, true);
            client.close();
        }
        File logDir = new File(this._logDirPath);
        logDir.mkdirs();
        props.put("zookeeper.session.timeout.ms", "60000");
        this._serverStartable = new KafkaServer(new KafkaConfig(props), Time.SYSTEM, Option.empty(), false);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", "localhost:" + this._port);
        config.put("client.id", "Kafka2AdminClient-" + UUID.randomUUID().toString());
        config.put("request.timeout.ms", 15000);
        this._adminClient = KafkaAdminClient.create(config);
    }

    public void start() {
        this._serverStartable.startup();
    }

    public void stop() {
        this._serverStartable.shutdown();
        FileUtils.deleteQuietly((File)new File((String)this._serverStartable.config().logDirs().apply(false)));
    }

    public void createTopic(final String topic, Properties props) {
        int partition = (Integer)props.get("partition");
        List<NewTopic> topicList = Arrays.asList(new NewTopic(topic, partition, 1));
        this._adminClient.createTopics(topicList);
        KafkaDataServerStartable.waitForCondition(new Function<Void, Boolean>(){

            @Nullable
            public Boolean apply(@Nullable Void aVoid) {
                try {
                    return KafkaDataServerStartable.this._adminClient.listTopics().names().get().contains(topic);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not fetch Kafka topics", e);
                    return null;
                }
            }
        }, 1000L, 30000L, "Kafka topic " + topic + " is not created yet");
    }

    public int getPort() {
        return this._port;
    }

    private static void waitForCondition(Function<Void, Boolean> condition, long checkIntervalMs, long timeoutMs, @Nullable String errorMessage) {
        Object errorMessageSuffix;
        long endTime = System.currentTimeMillis() + timeoutMs;
        Object object = errorMessageSuffix = errorMessage != null ? ", error message: " + errorMessage : "";
        while (System.currentTimeMillis() < endTime) {
            try {
                if (Boolean.TRUE.equals(condition.apply(null))) {
                    return;
                }
                Thread.sleep(checkIntervalMs);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while checking the condition" + (String)errorMessageSuffix, e);
            }
        }
        LOGGER.error("Failed to meet condition in " + timeoutMs + "ms" + (String)errorMessageSuffix);
    }
}

