/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.plugin.stream.kafka20.KafkaConsumerPartitionLag;
import org.apache.pinot.plugin.stream.kafka20.KafkaPartitionLevelConnectionHandler;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.pinot.shaded.org.apache.kafka.common.errors.TimeoutException;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.PartitionLagState;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;
import org.apache.pinot.spi.stream.TransientConsumerException;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStreamMetadataProvider
extends KafkaPartitionLevelConnectionHandler
implements StreamMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaStreamMetadataProvider.class);

    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig) {
        this(clientId, streamConfig, Integer.MIN_VALUE);
    }

    public KafkaStreamMetadataProvider(String clientId, StreamConfig streamConfig, int partition) {
        super(clientId, streamConfig, partition);
    }

    public int fetchPartitionCount(long timeoutMillis) {
        try {
            return this._consumer.partitionsFor(this._topic, Duration.ofMillis(timeoutMillis)).size();
        }
        catch (TimeoutException e) {
            throw new TransientConsumerException((Throwable)e);
        }
    }

    public StreamPartitionMsgOffset fetchStreamPartitionOffset(OffsetCriteria offsetCriteria, long timeoutMillis) {
        Preconditions.checkNotNull((Object)offsetCriteria);
        try {
            long offset;
            if (offsetCriteria.isLargest()) {
                offset = this._consumer.endOffsets(Collections.singletonList(this._topicPartition), Duration.ofMillis(timeoutMillis)).get(this._topicPartition);
            } else if (offsetCriteria.isSmallest()) {
                offset = this._consumer.beginningOffsets(Collections.singletonList(this._topicPartition), Duration.ofMillis(timeoutMillis)).get(this._topicPartition);
            } else if (offsetCriteria.isPeriod()) {
                OffsetAndTimestamp offsetAndTimestamp = this._consumer.offsetsForTimes(Collections.singletonMap(this._topicPartition, Clock.systemUTC().millis() - TimeUtils.convertPeriodToMillis((String)offsetCriteria.getOffsetString()))).get(this._topicPartition);
                if (offsetAndTimestamp == null) {
                    offset = this._consumer.endOffsets(Collections.singletonList(this._topicPartition), Duration.ofMillis(timeoutMillis)).get(this._topicPartition);
                    LOGGER.warn("initial offset type is period and its value evaluates to null hence proceeding with offset " + offset + "for topic " + this._topicPartition.topic() + " partition " + this._topicPartition.partition());
                } else {
                    offset = offsetAndTimestamp.offset();
                }
            } else if (offsetCriteria.isTimestamp()) {
                OffsetAndTimestamp offsetAndTimestamp = this._consumer.offsetsForTimes(Collections.singletonMap(this._topicPartition, TimeUtils.convertTimestampToMillis((String)offsetCriteria.getOffsetString()))).get(this._topicPartition);
                if (offsetAndTimestamp == null) {
                    offset = this._consumer.endOffsets(Collections.singletonList(this._topicPartition), Duration.ofMillis(timeoutMillis)).get(this._topicPartition);
                    LOGGER.warn("initial offset type is timestamp and its value evaluates to null hence proceeding with offset " + offset + "for topic " + this._topicPartition.topic() + " partition " + this._topicPartition.partition());
                } else {
                    offset = offsetAndTimestamp.offset();
                }
            } else {
                throw new IllegalArgumentException("Unknown initial offset value " + offsetCriteria);
            }
            return new LongMsgOffset(offset);
        }
        catch (TimeoutException e) {
            throw new TransientConsumerException((Throwable)e);
        }
    }

    public Map<String, PartitionLagState> getCurrentPartitionLagState(Map<String, ConsumerPartitionState> currentPartitionStateMap) {
        HashMap<String, PartitionLagState> perPartitionLag = new HashMap<String, PartitionLagState>();
        for (Map.Entry<String, ConsumerPartitionState> entry : currentPartitionStateMap.entrySet()) {
            ConsumerPartitionState partitionState = entry.getValue();
            StreamPartitionMsgOffset currentOffset = partitionState.getCurrentOffset();
            StreamPartitionMsgOffset upstreamLatest = partitionState.getUpstreamLatestOffset();
            String offsetLagString = "UNKNOWN";
            if (currentOffset instanceof LongMsgOffset && upstreamLatest instanceof LongMsgOffset) {
                long offsetLag = ((LongMsgOffset)upstreamLatest).getOffset() - ((LongMsgOffset)currentOffset).getOffset();
                offsetLagString = String.valueOf(offsetLag);
            }
            String availabilityLagMs = "UNKNOWN";
            RowMetadata lastProcessedMessageMetadata = partitionState.getLastProcessedRowMetadata();
            if (lastProcessedMessageMetadata != null && partitionState.getLastProcessedTimeMs() > 0L) {
                long availabilityLag = partitionState.getLastProcessedTimeMs() - lastProcessedMessageMetadata.getRecordIngestionTimeMs();
                availabilityLagMs = String.valueOf(availabilityLag);
            }
            perPartitionLag.put(entry.getKey(), new KafkaConsumerPartitionLag(offsetLagString, availabilityLagMs));
        }
        return perPartitionLag;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

