/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.stream.kafka20;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.plugin.stream.kafka20.KafkaMetadataExtractor;
import org.apache.pinot.plugin.stream.kafka20.KafkaPartitionLevelStreamConfig;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.Consumer;
import org.apache.pinot.shaded.org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.pinot.shaded.org.apache.kafka.common.KafkaException;
import org.apache.pinot.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.pinot.shaded.org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.pinot.shaded.org.apache.kafka.common.utils.Bytes;
import org.apache.pinot.spi.stream.StreamConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaPartitionLevelConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionLevelConnectionHandler.class);
    protected final KafkaPartitionLevelStreamConfig _config;
    protected final String _clientId;
    protected final int _partition;
    protected final String _topic;
    protected final Consumer<String, Bytes> _consumer;
    protected final TopicPartition _topicPartition;
    protected final KafkaMetadataExtractor _kafkaMetadataExtractor;

    public KafkaPartitionLevelConnectionHandler(String clientId, StreamConfig streamConfig, int partition) {
        this._config = new KafkaPartitionLevelStreamConfig(streamConfig);
        this._clientId = clientId;
        this._partition = partition;
        this._topic = this._config.getKafkaTopicName();
        Properties consumerProp = new Properties();
        consumerProp.putAll((Map<?, ?>)streamConfig.getStreamConfigsMap());
        consumerProp.put("bootstrap.servers", this._config.getBootstrapHosts());
        consumerProp.put("key.deserializer", StringDeserializer.class.getName());
        consumerProp.put("value.deserializer", BytesDeserializer.class.getName());
        if (this._config.getKafkaIsolationLevel() != null) {
            consumerProp.put("isolation.level", this._config.getKafkaIsolationLevel());
        }
        consumerProp.put("client.id", this._clientId);
        this._consumer = this.createConsumer(consumerProp);
        this._topicPartition = new TopicPartition(this._topic, this._partition);
        this._consumer.assign(Collections.singletonList(this._topicPartition));
        this._kafkaMetadataExtractor = KafkaMetadataExtractor.build(this._config.isPopulateMetadata());
    }

    private Consumer<String, Bytes> createConsumer(Properties consumerProp) {
        int maxTries = 5;
        int tries = 0;
        while (true) {
            try {
                return new KafkaConsumer<String, Bytes>(consumerProp);
            }
            catch (KafkaException e) {
                if (++tries >= maxTries) {
                    LOGGER.error("Caught exception while creating Kafka consumer, giving up", e);
                    throw e;
                }
                LOGGER.warn("Caught exception while creating Kafka consumer, retrying {}/{}", tries, maxTries, e);
                Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        this._consumer.close();
    }

    @VisibleForTesting
    protected KafkaPartitionLevelStreamConfig getKafkaPartitionLevelStreamConfig() {
        return this._config;
    }
}

